@echo off

setlocal 

set INTERNAL=%1
set USER=%2
set PASS=%3
set CONNECTION_STRING=%4
rem remove quotes from the connection string
set CONNECTION_STRING=%CONNECTION_STRING:"=%
set KRB_CONF_FILE=krb5.conf
set JAAS_CONF_FILE=%5
set JB_HOME=%6
rem remove quotes
set JB_HOME=%JB_HOME:"=%
set JB_PROFILE=%7
rem remove quotes
set JB_PROFILE=%JB_PROFILE:"=%
set FLAT_STRUCTURE=%8
set MIXED_MODE=%9
set EAR_LIB=server\%JB_PROFILE%\deploy\rhevm.ear\lib

if "%INTERNAL%"=="1" (
    set INTERNAL=/b
) else (
    set INTERNAL=
)

if "-%8"=="-" goto usage

rem When FLAT_STRUCTURE is yes, all jars are assumed to rest under the same folder.
rem This is used during installation where Jboss is not extracted yet.
if "%FLAT_STRUCTURE%"=="yes" (
    set CLASSPATH="%JB_HOME%\utils-3.0.1-0001.jar";"%JB_HOME%\rhevm-compat.jar;%JB_HOME%\commons-logging.jar";"%JB_HOME%\sqljdbc4.jar";"%JB_HOME%\rhevmencryptutils-3.0.1-0001.jar";"%JB_HOME%\commons-codec-1.4.jar"
) else (
    set CLASSPATH="%JB_HOME%\%EAR_LIB%\utils-3.0.1-0001.jar";"%JB_HOME%\%EAR_LIB%\rhevm-compat.jar";"%JB_HOME%\common\lib\commons-logging.jar";"%JB_HOME%\common\lib\sqljdbc4.jar";"%JB_HOME%\%EAR_LIB%\rhevmencryptutils-3.0.1-0001.jar";"%JB_HOME%\%EAR_LIB%\commons-codec-1.4.jar"
)

if "-%MIXED_MODE%"=="-" (	
	echo detect mixed mode
    java -cp %CLASSPATH% org.ovirt.engine.core.utils.kerberos.DetectMixedMode "%JB_HOME%\server\%JB_PROFILE%\conf\%KRB_CONF_FILE%" > res.tmp
	findstr /c:yes res.tmp || goto mixedModeDisabled 
	goto mixedModeEnabled
) else (
	goto createKrbFile
)

:mixedModeEnabled
set MIXED_MODE=yes
echo set mixed mode: %MIXED_MODE%
goto createKrbFile

:mixedModeDisabled
set MIXED_MODE=no
echo set mixed mode: %MIXED_MODE%
goto createKrbFile

:createKrbFile
echo creating the krb5.conf file...
java -cp %CLASSPATH% org.ovirt.engine.core.utils.kerberos.KerberosUpgrade -user=%USER% -password=%PASS% -connection_string=%CONNECTION_STRING% -jaas_file=%JAAS_CONF_FILE% -mixed_mode=%MIXED_MODE% -krb5_conf_path=%KRB_CONF_FILE% || set EXITCODE=1
if NOT "%EXITCODE%"=="1"  (
	goto end
) else (
 goto error
)
goto end


:error 
set ERRORLEVEL=1
echo Error: error creating krb5.conf file
goto end 

:end
exit %INTERNAL% %ERRORLEVEL%

:usage
echo Usage:
echo 	%0% [internal] [DBuser] [DBpass] [connection_string] [jass conf] [jboss home] [jboss profile] [flat_structure] [mixed-mode]
echo Where:
echo    internal			= 0  exit , 1  exit /b
echo 	DBuser				= DB username
echo 	DBpass				= DB password
echo 	connection_string	= DB connection string
echo 	jass conf			= jass conf path.
echo 	jboss home			= path to jboss-as dir
echo 	jboss profile		= jboss profile
echo 	flat_structure		= [y/n] is target jar directory flat or in Jboss installation hierarchy
echo 	mixed_mode			= [y/n] use AD in 2003 mixed mode.
goto error
