﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using org.ovirt.engine.ui.uicommon.dataprovider;
using org.ovirt.engine.ui.uicommon.models.vms;
using org.ovirt.engine.ui.uicompat;
using VdcCommon.BusinessEntities;
using VdcFrontend;

namespace org.ovirt.engine.ui.uicommon.models.userportal
{
	public class PoolItemBehavior : ItemBehavior
	{
		public PoolItemBehavior(UserPortalItemModel item)
			: base(item)
		{
		}

		public override void OnEntityChanged()
		{
			UpdateProperties();
			UpdateActionAvailability();
		}

		public override void EntityPropertyChanged(PropertyChangedEventArgs e)
		{
		}

		public override void ExecuteCommand(UICommand command)
		{
			if (command == Item.TakeVmCommand)
			{
				TakeVm();
			}
		}

		public override void eventRaised(Event ev, object sender, EventArgs args)
		{
			//Do nothing. There are no events to handle for pools.
		}

		private void TakeVm()
		{
			vm_pools entity = (vm_pools)Item.Entity;

			Frontend.RunAction(VdcActionType.AttachUserToVmFromPoolAndRun,
				new VmPoolUserParameters(entity.vm_pool_id, Frontend.LoggedInUser, false),
				result =>
				{
					PoolItemBehavior behavior = (PoolItemBehavior)result.State;
					VdcReturnValueBase returnValueBase = result.ReturnValue;
					Guid guid = (Guid)returnValueBase.ActionReturnValue;
					behavior.PostTakeVm(guid);
				},
				this
			);
		}

		public void PostTakeVm(Guid vmId)
		{
			AsyncDataProvider.GetVmById(new AsyncQuery(this,
				(target, returnValue) =>
				{
					PoolItemBehavior behavior = (PoolItemBehavior)target;

					UserPortalItemModel model = behavior.Item;
					model.Entity = returnValue;
				})
				, vmId
			);
		}

		private void UpdateProperties()
		{
			vm_pools entity = (vm_pools)Item.Entity;

			Item.Name = entity.vm_pool_name;
			Item.Description = entity.vm_pool_description;
			Item.IsPool = true;
			Item.IsServer = false;
			Item.Status = VMStatus.Down;
			Item.IsFromPool = false;
			Item.PoolType = entity.vm_pool_type;

			AsyncDataProvider.GetAnyVm(new AsyncQuery(this,
				(target, returnValue) =>
				{
					PoolItemBehavior behavior = (PoolItemBehavior)target;

					VM vm = (VM)returnValue;
					if (vm != null)
					{
						UserPortalItemModel model = behavior.Item;
						model.OsType = vm.vm_os;
					}
				})
				, entity.vm_pool_name
			);
		}

		private void UpdateActionAvailability()
		{
			Item.TakeVmCommand.IsAvailable = true;

			Item.RunCommand.IsAvailable = false;
			Item.PauseCommand.IsAvailable = true;
			Item.ShutdownCommand.IsAvailable = true;
			Item.StopCommand.IsAvailable = true;
			Item.ReturnVmCommand.IsAvailable = false;

			Item.PauseCommand.IsExecutionAllowed = false;
			Item.ShutdownCommand.IsExecutionAllowed = false;
			Item.StopCommand.IsExecutionAllowed = false;
		}
	}
}