﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Threading;
using org.ovirt.engine.ui.uicommon;
using org.ovirt.engine.ui.uicompat;

namespace UI.WPFClient
{
	public class WPFTimer : ITimer
	{
		private readonly DispatcherTimer timer;

		public Event TickEvent { get; private set; }

		public int Interval
		{
			get { return (int)timer.Interval.TotalMilliseconds; }
			set { timer.Interval = TimeSpan.FromMilliseconds(value); }
		}

		public void Start()
		{
			timer.Start();
		}

		public void Stop()
		{
			timer.Stop();
		}

		public WPFTimer()
		{
			TickEvent = new Event(ProvideTickEvent.Definition);

			timer = new DispatcherTimer();
			timer.Tick +=
				(sender, e) =>
				{
					TickEvent.raise(this, EventArgs.Empty);
				};
		}
	}
}
