PRINT 'Processing image_vm_map_sp.sql'

----------------------------------------------------------------
-- [dbo].[image_vm_map] Table
--
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Insertimage_vm_map')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Insertimage_vm_map] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Insertimage_vm_map]
    @active bit = NULL,
	@image_id uniqueidentifier,
	@vm_id uniqueidentifier
AS
BEGIN
	SET NOCOUNT ON
	
	BEGIN TRY
    INSERT INTO [dbo].[image_vm_map] ([active], [image_id], [vm_id])
	VALUES (@active, @image_id, @vm_id)
    
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH
    
    SET NOCOUNT OFF
END    

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Updateimage_vm_map')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Updateimage_vm_map] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Updateimage_vm_map]
    @active bit = NULL,
	@image_id uniqueidentifier,
	@vm_id uniqueidentifier
AS
BEGIN

	--The [dbo].[image_vm_map] table doesn't have a timestamp column. Optimistic concurrency logic cannot be generated
	SET NOCOUNT ON

	BEGIN TRY
	UPDATE [dbo].[image_vm_map] 
	SET [active] = @active
	WHERE [image_id]=@image_id AND [vm_id]=@vm_id

	IF @@ROWCOUNT = 0
	BEGIN
		RAISERROR('Update statement affected 0 rows.', 16, 2)
	END
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH	

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Deleteimage_vm_map')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Deleteimage_vm_map] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Deleteimage_vm_map]
	 @image_id uniqueidentifier,
	@vm_id uniqueidentifier
AS
BEGIN
	SET NOCOUNT ON
	BEGIN TRY
		DELETE FROM [dbo].[image_vm_map]
		WHERE [image_id]=@image_id AND [vm_id]=@vm_id
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH
    
    SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetAllFromimage_vm_map')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetAllFromimage_vm_map] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetAllFromimage_vm_map]    
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY	
		SELECT
		[image_vm_map].[active] AS 'active',
		[image_vm_map].[image_id] AS 'image_id',
		[image_vm_map].[vm_id] AS 'vm_id'
	FROM [dbo].[image_vm_map] [image_vm_map]
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Getimage_vm_mapByimage_idAndByvm_id')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Getimage_vm_mapByimage_idAndByvm_id] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Getimage_vm_mapByimage_idAndByvm_id] 
	@image_id uniqueidentifier,
	@vm_id uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		[image_vm_map].[active] AS 'active',
		[image_vm_map].[image_id] AS 'image_id',
		[image_vm_map].[vm_id] AS 'vm_id'
		FROM [dbo].[image_vm_map] [image_vm_map]
		WHERE [image_id]=@image_id AND [vm_id]=@vm_id
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Getimage_vm_mapByimage_id')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Getimage_vm_mapByimage_id] AS RETURN')
END

GO
ALTER PROCEDURE [dbo].[Getimage_vm_mapByimage_id] 
	@image_id uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		[image_vm_map].[active] AS 'active',
		[image_vm_map].[image_id] AS 'image_id',
		[image_vm_map].[vm_id] AS 'vm_id'
		FROM [dbo].[image_vm_map] [image_vm_map]
		WHERE [image_id]=@image_id
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END


GO


IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Getimage_vm_mapByvm_id')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Getimage_vm_mapByvm_id] AS RETURN')
END

GO
ALTER PROCEDURE [dbo].[Getimage_vm_mapByvm_id] 
	@vm_id uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		[image_vm_map].[active] AS 'active',
		[image_vm_map].[image_id] AS 'image_id',
		[image_vm_map].[vm_id] AS 'vm_id'
		FROM [dbo].[image_vm_map] [image_vm_map]
		WHERE [vm_id]=@vm_id
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO
