using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Text;
using org.ovirt.engine.ui.uicommon.models.vms;
using VdcCommon.Interfaces;
using VdcCommon.BusinessEntities;
using VdcFrontend;
using VdcCommon.VdcQueries;
using System.Collections;
using System.ComponentModel;

namespace org.ovirt.engine.ui.uicommon.models.hosts
{
	public class HostHooksListModel : SearchableListModel
	{
		#region Properties

		public new VDS Entity
		{
			get { return (VDS)base.Entity; }
			set { base.Entity = value; }
		}

		#endregion

		public HostHooksListModel()
		{
			Title = "Host Hooks";
		}

		protected override void OnEntityChanged()
		{
			base.OnEntityChanged();

			SearchCommand.Execute();
		}

		protected override void EntityPropertyChanged(object sender, PropertyChangedEventArgs e)
		{
			base.EntityPropertyChanged(sender, e);

			if (e.PropertyName == "status")
			{
				SearchCommand.Execute();
			}
		}

		public override void Search()
		{
			if (Entity != null)
			{
				base.Search();
			}
		}

		protected override void SyncSearch()
		{
			if (!Entity.ContainingHooks)
			{
				IsEmpty = true;
				Items = null;
				return;
			}

			base.SyncSearch();

			IsEmpty = false;

			VdcQueryReturnValue retValue =
				Frontend.RunQuery(
					VdcQueryType.GetVdsHooksById,
					new GetVdsHooksByIdParameters { VdsId = Entity.vds_id });

			List<Dictionary<string, string>> list = new List<Dictionary<string, string>>();
			if (retValue != null && retValue.Succeeded)
			{
				Dictionary<string, Dictionary<string, Dictionary<string, string>>> dictionary =
					(Dictionary<string, Dictionary<string, Dictionary<string, string>>>)retValue.ReturnValue;
				Dictionary<string, string> row;
				foreach (KeyValuePair<string, Dictionary<string, Dictionary<string, string>>> keyValuePair in dictionary)
				{
					foreach (KeyValuePair<string, Dictionary<string, string>> keyValuePair1 in keyValuePair.Value)
					{
						foreach (KeyValuePair<string, string> keyValuePair2 in keyValuePair1.Value)
						{
							row = new Dictionary<string, string>();
							row.Add("EventName", keyValuePair.Key);
							row.Add("ScriptName", keyValuePair1.Key);
							row.Add("PropertyName", keyValuePair2.Key);
							row.Add("PropertyValue", keyValuePair2.Value);
							list.Add(row);
						}
					}
				}
				Items = list;
			}
			else
			{
				Items = null;
			}
		}

		protected override void AsyncSearch()
		{
			base.AsyncSearch();
			SyncSearch();
		}
	}
}
