using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Text;
using org.ovirt.engine.ui.uicompat;

namespace org.ovirt.engine.ui.uicommon.models.storage
{
	public class SanTargetModel : Model
	{
		#region Events

		public static EventDefinition LoggedInEventDefinition;
		public Event LoggedInEvent { get; private set; }

		#endregion

		#region Commands

		public UICommand LoginCommand { get; set; }

		#endregion

		#region Properties

		private string address;
		public string Address
		{
			get { return address; }
			set
			{
				if (address != value)
				{
					address = value;
					OnPropertyChanged(new PropertyChangedEventArgs("Address"));
				}
			}
		}

		private string port;
		public string Port
		{
			get { return port; }
			set
			{
				if (port != value)
				{
					port = value;
					OnPropertyChanged(new PropertyChangedEventArgs("Port"));
				}
			}
		}

		private string name;
		public string Name
		{
			get { return name; }
			set
			{
				if (name != value)
				{
					name = value;
					OnPropertyChanged(new PropertyChangedEventArgs("Name"));
				}
			}
		}

		private bool isLoggedIn;
		public bool IsLoggedIn
		{
			get { return isLoggedIn; }
			set
			{
				if (isLoggedIn != value)
				{
					isLoggedIn = value;
					OnPropertyChanged(new PropertyChangedEventArgs("IsLoggedIn"));
				}
			}
		}

		private IList<LunModel> luns;
		public IList<LunModel> Luns
		{
			get { return luns; }
			set
			{
				if (luns != value)
				{
					luns = value;
					OnPropertyChanged(new PropertyChangedEventArgs("Luns"));
				}
			}
		}

		#endregion

		static SanTargetModel()
		{
			LoggedInEventDefinition = new EventDefinition("LoggedIn", typeof(SanTargetModel));
		}

		public SanTargetModel()
		{
			LoggedInEvent = new Event(LoggedInEventDefinition);

			LoginCommand = new UICommand("Login", this);
		}

		private void Login()
		{
			LoggedInEvent.raise(this, EventArgs.Empty);
		}

		public override void ExecuteCommand(UICommand command)
		{
			base.ExecuteCommand(command);

			if (command == LoginCommand)
			{
				Login();
			}
		}
	}
}
