"""
provides all the predefined variables for rhevm-setup
"""
import os

DB_ADMIN="postgres"
DB_NAME="rhevm"
DB_HOST="localhost"
DB_USER="rhevm"
DB_PORT="5432"
DB_PASS_FILE="/root/.pgpass"
PGPASS_FILE_TEMPLATE="hostname:port:database:username:password"
JBOSS_SECURITY_DOMAIN="EncryptDBPassword"
JBOSS_KERB_AUTH="RHEVKerberosAuth"

JBOSS_PROFILE_NAME="rhevm-slimmed"
VDC_OPTION_CVER="general"
RHEVM_RPM_NAME="rhevm"
RPM_LOCK_LIST="rhevm-genericapi rhevm rhevm-backend rhevm-admin-portal-wpf rhevm-jboss-deps \
rhevm-userportal rhevm-restapi rhevm-config rhevm-tools-common rhevm-notification-service"

JBOSS_SHARE_FOLDER="/usr/share/jbossas"

INTERNAL_ADMIN="admin"
INTERNAL_DOMAIN="internal"

DIR_ETC_SYSCONFIG="/etc/sysconfig"
DIR_USR_SHARE="/usr/share"
DIR_VAR_LOG="/var/log"
DIR_VAR_LIB="/var/lib"
DIR_LOG="%s/rhevm/" % (DIR_VAR_LOG)
DIR_CONFIG="%s/rhevm/conf" % (DIR_USR_SHARE)
DIR_JBOSS_RESOURCES="%s/rhevm/resources/jboss" % (DIR_USR_SHARE)
DIR_KERBEROS="%s/rhevm/kerberos" % (DIR_USR_SHARE)
DIR_JBOSS="%s/jbossas" % (DIR_VAR_LIB)

DIR_JBOSS_ROOT_WAR_IMAGES_SRC="%s/%s" % (DIR_JBOSS_RESOURCES, "images/")
DIR_JBOSS_ROOT_WAR="%s/server/%s/deploy/ROOT.war" % (DIR_JBOSS, JBOSS_PROFILE_NAME)
DIR_RHEVM_EAR_SRC="%s/rhevm/rhevm.ear" % (DIR_USR_SHARE)
DIR_DB_SCRIPTS="%s/rhevm/dbscripts/" % (DIR_USR_SHARE)
DIR_DB_BACKUPS="%s/rhevm/db-backups" % (DIR_USR_SHARE)
DIR_RHEVM_CONFIG="%s/rhevm/rhevm-config/" % (DIR_USR_SHARE)
DIR_RHEVM_CONFIG_CONF="/etc/rhevm/rhevm-config/"
DIR_RHEVM_PKI="/etc/pki/rhevm"

FILE_INSTALLER_LOG="rhevm-setup.log"
FILE_JBOSS_HTTP_PARAMS="/etc/rhevm/web-conf.js"
FILE_JBOSS_ROOT_WAR_CSS = "style.css"
FILE_JBOSS_ROOT_WAR_CSS_SRC="%s/%s" % (DIR_JBOSS_RESOURCES, FILE_JBOSS_ROOT_WAR_CSS)
FILE_JBOSS_LOG4J_XML_DEST="%s/server/%s/conf/jboss-log4j.xml" % (DIR_JBOSS, JBOSS_PROFILE_NAME)
FILE_JBOSS_LOG4J_XML_SRC="%s/rhevm/conf/jboss-log4j.xml" % (DIR_USR_SHARE)
FILE_JBOSS_WEB_XML_SRC="%s/server/%s/deploy/ROOT.war/WEB-INF/web.xml" % (DIR_JBOSS, JBOSS_PROFILE_NAME)
FILE_JBOSS_TRANS_XML_SRC="%s/server/%s/deploy/transaction-jboss-beans.xml" % (DIR_JBOSS, JBOSS_PROFILE_NAME)
FILE_JBOSS_SERVER_XML="%s/server/%s/deploy/jbossweb.sar/server.xml" % (DIR_JBOSS, JBOSS_PROFILE_NAME)
FILE_JBOSS_BEANS_XML="/etc/jbossas/%s/bindingservice.beans/META-INF/bindings-jboss-beans.xml" % (JBOSS_PROFILE_NAME)
FILE_JBOSS_PGSQL_DS_XML_SRC="%s/postgres-ds.xml" % (DIR_CONFIG)
FILE_JBOSS_PGSQL_DS_XML_DEST="%s/server/%s/deploy/postgres-ds.xml" % (DIR_JBOSS, JBOSS_PROFILE_NAME)
FILE_EXTERNAL_CONFIG="%s/rhevm/rhevm.ear/rhevmanager.war/ExternalConfig.txt" % (DIR_USR_SHARE)
FILE_DEFAULT_HTML="%s/rhevm/rhevm.ear/rhevmanager.war/Default.htm" % (DIR_USR_SHARE)
FILE_SERVER_PARAMS_JS="%s/rhevm/rhevm.ear/rhevmanager.war/ServerParameters.js" % (DIR_USR_SHARE)
FILE_LOGIN_CONFIG_XML="%s/server/%s/conf/login-config.xml" % (DIR_JBOSS, JBOSS_PROFILE_NAME)
FILE_KRB_CONF="%s/server/%s/conf/krb5.conf" % (DIR_JBOSS, JBOSS_PROFILE_NAME)
FILE_CA_CRT_SRC="/etc/pki/rhevm/ca.pem"
FILE_CA_CRT_TEMPLATE="/etc/pki/rhevm/cacert.template"
FILE_CERT_TEMPLATE="/etc/pki/rhevm/cert.template"
FILE_JBOSSAS_CONF="/etc/jbossas/jbossas.conf"
FILE_JBOSS_ROOT_WAR_HTML="rhevm_index.html"
FILE_JBOSS_ROOT_WAR_HTML_DEST="%s/%s" % (DIR_JBOSS_ROOT_WAR, FILE_JBOSS_ROOT_WAR_HTML)
FILE_JBOSS_ROOT_WAR_HTML_SRC="%s/%s" % (DIR_JBOSS_RESOURCES, FILE_JBOSS_ROOT_WAR_HTML)
FILE_JBOSS_ROOT_WAR_JS_VERSION="rhevmVersion.js"
FILE_JBOSS_ROOT_WAR_CONTEXT_SRC="%s/ROOT_war-context.xml" % DIR_JBOSS_RESOURCES
FILE_JBOSS_ROOT_WAR_CONTEXT_DEST="%s/WEB-INF/context.xml" % DIR_JBOSS_ROOT_WAR
FILE_JBOSS_ROOT_WAR_FAVICON="favicon.ico"
FILE_JBOSS_ROOT_WAR_FAVICON_DEST="%s/%s" % (DIR_JBOSS_ROOT_WAR, FILE_JBOSS_ROOT_WAR_FAVICON)
FILE_JBOSS_ROOT_WAR_FAVICON_SRC="%s/%s" % (DIR_JBOSS_RESOURCES, FILE_JBOSS_ROOT_WAR_FAVICON)
FILE_DB_INSTALL_SCRIPT="rhevm-db-install.sh"
FILE_DB_UPGRADE_SCRIPT="upgrade.sh"
FILE_RHEVM_CONFIG_BIN=os.path.join(DIR_RHEVM_CONFIG, "rhevm-config")
FILE_RHEVM_CONFIG_PROPS="rhevm-config-install.properties"
FILE_RHEVM_EXTENDED_CONF = os.path.join(DIR_CONFIG, FILE_RHEVM_CONFIG_PROPS)
FILE_RESOLV_CONF="/etc/resolv.conf"
FILE_SLIMMING_PROFILE_CONF="/usr/share/rhevm/conf/slimming.conf"
FILE_IPTABLES_DEFAULT="%s/rhevm/conf/iptables.default" % (DIR_USR_SHARE)
FILE_IPTABLES_EXAMPLE="%s/rhevm/conf/iptables.example" % (DIR_USR_SHARE)
FILE_IPTABLES_BACKUP="%s/rhevm/conf/iptables.backup" % (DIR_USR_SHARE)
FILE_NFS_SYSCONFIG="%s/rhevm/conf/nfs.sysconfig" % (DIR_USR_SHARE)
FILE_NFS_BACKUP="%s/rhevm/conf/nfs.backup" % (DIR_USR_SHARE)
FILE_ETC_EXPORTS="/etc/exports"
FILE_PUBLIC_SSH_KEY="/etc/pki/rhevm/keys/rhevm.ssh.key.txt"
FILE_YUM_VERSION_LOCK="/etc/yum/pluginconf.d/versionlock.list"
FILE_ISOUPLOADER_CONF="/etc/rhevm/isouploader.conf"
FILE_LOGCOLLECTOR_CONF="/etc/rhevm/logcollector.conf"
FILE_PSQL_CONF="/var/lib/pgsql/data/postgresql.conf"
FILE_LIMITS_CONF="/etc/security/limits.conf"

# ISO FILES
FILE_VIRTIO_WIN_VFD="/usr/share/virtio-win/virtio-win.vfd"
FILE_VIRTIO_WIN_ISO="/usr/share/virtio-win/virtio-win.iso"
FILE_RHEV_GUEST_TOOLS_ISO="/usr/share/rhev-guest-tools-iso/rhev-tools-setup.iso"

EXEC_IPTABLES="/sbin/iptables"
EXEC_SLIMMING_PROFILE="%s/rhevm/scripts/slimmingEAP51.sh" % (DIR_USR_SHARE)
EXEC_NSLOOKUP="/usr/bin/nslookup"
EXEC_IP="/sbin/ip"
EXEC_EXPORTFS="/usr/sbin/exportfs"
EXEC_SEMANAGE="/usr/sbin/semanage"
EXEC_RESTORECON="/sbin/restorecon"
EXEC_SERVICE="/sbin/service"
EXEC_LSOF="/usr/sbin/lsof"
EXEC_ENCRYPT_PASS="/etc/pki/rhevm/encryptpasswd.sh"
EXEC_RPM="/bin/rpm"
EXEC_FREE="/usr/bin/free"
EXEC_DATE="/bin/date"
EXEC_OPENSSL="/usr/bin/openssl"
EXEC_PGDUMP="/usr/bin/pg_dump"
EXEC_PSQL="/usr/bin/psql"
EXEC_PGRESTORE="/usr/bin/pg_restore"
EXEC_DROPDB="/usr/bin/dropdb"
EXEC_SHELL="/bin/sh"
EXEC_SSH_KEYGEN="/usr/bin/ssh-keygen"

CONST_BASE_MAC_ADDR="00:1A:4A"
CONST_DEFAULT_MAC_RANGE="00:1a:4a:16:84:02-00:1a:4a:16:84:fd"
CONST_MINIMUM_SPACE_ISODOMAIN=350
CONST_HTTP_BASE_PORT="8080"
CONST_HTTPS_BASE_PORT="8443"
CONST_AJP_BASE_PORT="8009"
CONST_JBOSS_TRANS_TIMEOUT="600"
CONST_CA_PASS="mypass"
CONST_CA_COUNTRY="US"
CONST_CA_ALIAS="rhevm"
CONST_STORAGE_DOMAIN_NAME_SIZE_LIMIT=50
CONST_MIN_MEMORY_GB=2
CONST_WARN_MEMORY_GB=4
CONST_ORG_NAME_SIZE_LIMIT=64
CONST_VDSM_UID = 36
CONST_KVM_GID  = 36
CONST_MAX_PSQL_CONNS= 150
CONST_FD_OPEN = 65535
CONST_FD_LINE = "jboss           %s    nofile          %s"

#various xpath expressions
XPATH_LOGIN_CFG_APP_POLICY_KERB="//application-policy[@name='%s']" % JBOSS_KERB_AUTH
XPATH_LOGIN_CFG_APP_POLICY_PASS="//application-policy[@name='%s']" % JBOSS_SECURITY_DOMAIN
XPATH_LOGIN_CFG_AUTH_MODULE_OPT="%s/authentication/login-module/module-option" % (XPATH_LOGIN_CFG_APP_POLICY_PASS)
XPATH_LOGIN_CFG_UPD_PASS= "%s[@name='password']" % (XPATH_LOGIN_CFG_AUTH_MODULE_OPT)
XPATH_LOGIN_CFG_UPD_USER="%s[@name='username']" % (XPATH_LOGIN_CFG_AUTH_MODULE_OPT)

#text colors
RED="\033[0;31m"
GREEN="\033[92m"
BLUE="\033[94m"
YELLOW="\033[93m"
NO_COLOR="\033[0m"

#space len size for color print
SPACE_LEN=70
