#!/bin/bash

# https://community.jboss.org/wiki/JBoss5xTuningSlimming
# https://access.redhat.com/kb/docs/DOC-36442
# version: 1.3 Arnaud Simon script adapted from EAP 5.0 to EWP 5.1


DATE=$(date  +%Y%m%d-%H%M)
CONF_BASE_DIR="/usr/share/rhevm/conf"
ETC_DIR="/etc/jbossas"
LOG_DIR="/var/log/jbossas"

#set to any value to print to screen
DEBUG=""

#clear

# Checking JBOSS_HOME
if [ ! -d "$1" ] || [ ! -f "$2" ]; then
    echo "ERROR!"
    echo "[USAGE]: ./slimmingEAP51.sh <JBOSS_HOME> <SLIMMED_CONF>"
    exit 1
 else
    JBOSS_HOME=$1
    SLIMMED_CONF=$2
fi

# Checking SLIMMED_CONF
if [ ! -r "$SLIMMED_CONF" ]; then
    echo "Slimming configuration file doesn't exists!"
    echo "Please, create a file named slimming.conf with slimming configuration."
    exit 1
else
    . "$SLIMMED_CONF"
fi

rejectFileOrDirectory()
{
    debug  "Deleting $1"
    if [ -a "$1" ]; then
    rm -rf "$1"
    else
    debug "$1 doesn't exist!"
    fi
}

debug()
{
	if [ X${DEBUG}X != "XX" ]; then
		echo $1
	fi
}

#---------------------------------------------------------------------------------------------------------------------#
# Creating slimmed profile from default profile
debug ---------------------------------------------------------------------
debug "Creating slimmed profile named [${SLIMMED_PROFILE_NAME}] from [${BASE_PROFILE_NAME}] profile in ${JBOSS_HOME}/server/${SLIMMED_PROFILE_NAME}/."
if [ -d ${JBOSS_HOME}/server/${SLIMMED_PROFILE_NAME} ]; then
	mkdir ${JBOSS_HOME}/server/${SLIMMED_PROFILE_NAME}-bkp-$DATE-$$
	mv ${JBOSS_HOME}/server/${SLIMMED_PROFILE_NAME} ${JBOSS_HOME}/server/${SLIMMED_PROFILE_NAME}-bkp-$DATE-$$
fi

cp -rpf ${JBOSS_HOME}/server/${BASE_PROFILE_NAME} ${JBOSS_HOME}/server/${SLIMMED_PROFILE_NAME}

debug ---------------------------------------------------------------------
debug "Creating  ${ETC_DIR}/${SLIMMED_PROFILE_NAME} from ${ETC_DIR}/${BASE_PROFILE_NAME}"
if [ -d ${ETC_DIR}/${SLIMMED_PROFILE_NAME} ]; then
	mkdir ${ETC_DIR}/${SLIMMED_PROFILE_NAME}-bkp-$DATE-$$
	mv ${ETC_DIR}/${SLIMMED_PROFILE_NAME} ${ETC_DIR}/${SLIMMED_PROFILE_NAME}-bkp-$DATE-$$
fi

cp -rpf ${ETC_DIR}/${BASE_PROFILE_NAME} ${ETC_DIR}/${SLIMMED_PROFILE_NAME}

debug ---------------------------------------------------------------------
debug "Creating  ${LOG_DIR}/${SLIMMED_PROFILE_NAME} "
if [[ -d ${LOG_DIR}/${SLIMMED_PROFILE_NAME} ]]; then
	mkdir ${LOG_DIR}/${SLIMMED_PROFILE_NAME}-bkp-$DATE-$$
	mv ${LOG_DIR}/${SLIMMED_PROFILE_NAME} ${LOG_DIR}/${SLIMMED_PROFILE_NAME}-bkp-$DATE-$$
fi

mkdir -p ${LOG_DIR}/${SLIMMED_PROFILE_NAME}
chown jboss:jboss ${LOG_DIR}/${SLIMMED_PROFILE_NAME}
#wait for OS buffers to flush
sync

if [ -h ${JBOSS_HOME}/server/${SLIMMED_PROFILE_NAME}/conf ]; then
	rm -f ${JBOSS_HOME}/server/${SLIMMED_PROFILE_NAME}/conf
fi
ln -s ${ETC_DIR}/${SLIMMED_PROFILE_NAME} ${JBOSS_HOME}/server/${SLIMMED_PROFILE_NAME}/conf

if [ -h ${JBOSS_HOME}/server/${SLIMMED_PROFILE_NAME}/log ]; then
	rm -f ${JBOSS_HOME}/server/${SLIMMED_PROFILE_NAME}/log
fi
ln -s ${LOG_DIR}/${SLIMMED_PROFILE_NAME} ${JBOSS_HOME}/server/${SLIMMED_PROFILE_NAME}/log

#from here we remove the directories as per slimming.conf
# Removing EJB 2
if [ $REMOVE_EJB_2 = "Y" ]; then
	debug ---------------------------------------------------------------------
	debug "Removing EJB 2:"
	rejectFileOrDirectory ${JBOSS_HOME}/server/${SLIMMED_PROFILE_NAME}/deploy/ejb2-container-jboss-beans.xml
	if [ $REMOVE_EJB_3 = "Y" ]; then
		rejectFileOrDirectory ${JBOSS_HOME}/server/${SLIMMED_PROFILE_NAME}/deploy/ejb2-timer-service.xml
	fi
fi

# Removing EJB 3
if [ $REMOVE_EJB_3 = "Y" ]; then
	debug ---------------------------------------------------------------------
	debug "Removing EJB 3:"
	rejectFileOrDirectory ${JBOSS_HOME}/server/${SLIMMED_PROFILE_NAME}/deploy/ejb3-connectors-jboss-beans.xml
	rejectFileOrDirectory ${JBOSS_HOME}/server/${SLIMMED_PROFILE_NAME}/deploy/ejb3-container-jboss-beans.xml
	rejectFileOrDirectory ${JBOSS_HOME}/server/${SLIMMED_PROFILE_NAME}/deploy/ejb3-interceptors-aop.xml
	rejectFileOrDirectory ${JBOSS_HOME}/server/${SLIMMED_PROFILE_NAME}/deploy/ejb3-timerservice-jboss-beans.xml
fi

# Removing Hypersonic DB
if [ $REMOVE_Hypersonic_DB = "Y" ]; then
	debug ---------------------------------------------------------------------
	debug "Removing Hypersonic DB:"
	rejectFileOrDirectory ${JBOSS_HOME}/server/${SLIMMED_PROFILE_NAME}/deploy/hsqldb-ds.xml
	#not deleting b/c it is in common (the script only cleans up the domain)
	#rejectFileOrDirectory ${JBOSS_HOME}/jboss-as/common/lib/hsqldb.jar
fi

# Removing JBoss WS
if [ $REMOVE_JBoss_WS = "Y" ]; then
	debug ---------------------------------------------------------------------
	debug "Removing JBoss WS:"
	rejectFileOrDirectory ${JBOSS_HOME}/server/${SLIMMED_PROFILE_NAME}/deploy/jbossws.sar
	rejectFileOrDirectory ${JBOSS_HOME}/server/${SLIMMED_PROFILE_NAME}/deployers/jbossws.deployer
fi

# Removing JBoss Mail
if [ $REMOVE_JBoss_Mail = "Y" ]; then
	debug ---------------------------------------------------------------------
	debug "Removing JBoss Mail:"
	rejectFileOrDirectory ${JBOSS_HOME}/server/${SLIMMED_PROFILE_NAME}/deploy/mail-ra.rar
	rejectFileOrDirectory ${JBOSS_HOME}/server/${SLIMMED_PROFILE_NAME}/deploy/mail-service.xml
fi


# Removing Hot deployment
if [ $REMOVE_Hot_deployment = "Y" ]; then
	debug ---------------------------------------------------------------------
	debug "Removing Hot deployment"
	rejectFileOrDirectory ${JBOSS_HOME}/server/${SLIMMED_PROFILE_NAME}/deploy/hdscanner-jboss-beans.xml
fi

# Removing JMX Console
if [ $REMOVE_JMX_Console = "Y" ]; then
	debug ---------------------------------------------------------------------
	debug "Removing JMX Console:"
	rejectFileOrDirectory ${JBOSS_HOME}/server/${SLIMMED_PROFILE_NAME}/deploy/jmx-console.war
fi

# Removing Admin Console
if [ $REMOVE_Admin_Console = "Y" ]; then
	debug ---------------------------------------------------------------------
	debug "Removing Admin Console:"
	rejectFileOrDirectory ${JBOSS_HOME}/server/${SLIMMED_PROFILE_NAME}/deploy/admin-console.war
fi

# Removing Seam
if [ $REMOVE_Seam = "Y" ]; then
	debug ---------------------------------------------------------------------
	debug "Removing Seam:"
	rejectFileOrDirectory ${JBOSS_HOME}/server/${SLIMMED_PROFILE_NAME}/deployers/seam.deployer
fi

# Removing XA datasources
if [ $REMOVE_XA_datasources = "Y" ]; then
	debug ---------------------------------------------------------------------
	debug "Removing XA datasources:"
	rejectFileOrDirectory ${JBOSS_HOME}/server/${SLIMMED_PROFILE_NAME}/deploy/jboss-xa-jdbc.rar
	rejectFileOrDirectory ${JBOSS_HOME}/server/${SLIMMED_PROFILE_NAME}/deploy/jboss-xa-jdbc.jar
fi

# Removing root web application IP:8080/
if [ $REMOVE_ROOT_directory = "Y" ]; then
	debug ---------------------------------------------------------------------
	debug "Removing ROOT web application:"
	rejectFileOrDirectory ${JBOSS_HOME}/server/${SLIMMED_PROFILE_NAME}/deploy/ROOT.war
fi

# Removing remote (RMI) access to JMX
if [ $REMOVE_remote_JMX = "Y" ]; then
	debug ---------------------------------------------------------------------
	debug "Removing remote JMX:"
	rejectFileOrDirectory ${JBOSS_HOME}/server/${SLIMMED_PROFILE_NAME}/deploy/jmx-remoting.sar
fi

# Removing JCA resource adaptor that implements the JCA ManagedConnectionFactory interface for JDBC drivers that support the DataSource interface but not JCA
if [ $REMOVE_JBoss_JDBC_datasource = "Y" ]; then
	debug ---------------------------------------------------------------------
	debug "Removing JCA resource adaptor for JDBC driver support:"
	rejectFileOrDirectory ${JBOSS_HOME}/server/${SLIMMED_PROFILE_NAME}/deploy/jboss-local-jdbc.rar
fi


# Removing JUDDI
if [ $REMOVE_JUDDI = "Y" ]; then
	debug ---------------------------------------------------------------------
	debug "Removing JUDDI:"
	rejectFileOrDirectory ${JBOSS_HOME}/server/${SLIMMED_PROFILE_NAME}/deploy/juddi-service.sar
fi

# Removing Key Generator
if [ $REMOVE_Key_Generator = "Y" ]; then
	debug ---------------------------------------------------------------------
	debug "Removing Key Generator:"
	rejectFileOrDirectory ${JBOSS_HOME}/server/${SLIMMED_PROFILE_NAME}/deploy/uuid-key-generator.sar
fi

# Removing JMS (Java Message Service)
if [ $REMOVE_JMS = "Y" ]; then
	debug ---------------------------------------------------------------------
	debug "Removing JMS:"
	rejectFileOrDirectory ${JBOSS_HOME}/server/${SLIMMED_PROFILE_NAME}/deploy/messaging
	rejectFileOrDirectory ${JBOSS_HOME}/server/${SLIMMED_PROFILE_NAME}/deploy/jms-ra.rar
	rejectFileOrDirectory ${JBOSS_HOME}/server/${SLIMMED_PROFILE_NAME}/deploy/quartz-ra.rar
	rejectFileOrDirectory ${JBOSS_HOME}/server/${SLIMMED_PROFILE_NAME}/deployers/messaging-definitions-jboss-beans.xml
fi


# Removing JBoss Scheduling
if [ $REMOVE_JBoss_Scheduling = "Y" ]; then
	debug ---------------------------------------------------------------------
	debug "Removing JBoss Scheduling:"
	rejectFileOrDirectory ${JBOSS_HOME}/server/${SLIMMED_PROFILE_NAME}/deploy/scheduler-manager-service.xml
	rejectFileOrDirectory ${JBOSS_HOME}/server/${SLIMMED_PROFILE_NAME}/deploy/scheduler-service.xml
fi


# Removing Bsh Deployer
if [ $REMOVE_Bsh_Deployer = "Y" ]; then
	debug ---------------------------------------------------------------------
	debug "Removing Bsh Deployer:"
	rejectFileOrDirectory ${JBOSS_HOME}/server/${SLIMMED_PROFILE_NAME}/deploy/bsh.deployer
fi


# Removing xnio
if [ $REMOVE_xnio = "Y" ]; then
	debug ---------------------------------------------------------------------
	debug "Removing xnio:"
	rejectFileOrDirectory ${JBOSS_HOME}/server/${SLIMMED_PROFILE_NAME}/deploy/xnio-provider.jar
fi

# Removing SQLException
if [ $REMOVE_SQLException = "Y" ]; then
	debug ---------------------------------------------------------------------
	debug "Removing SQLException:"
	rejectFileOrDirectory ${JBOSS_HOME}/server/${SLIMMED_PROFILE_NAME}/deploy/sqlexception-service.xml
fi

# Removing HTTP invoker
if [ $REMOVE_HTTP_invoker = "Y" ]; then
	debug ---------------------------------------------------------------------
	debug "Removing HTTP invoker:"
	rejectFileOrDirectory ${JBOSS_HOME}/server/${SLIMMED_PROFILE_NAME}/deploy/http-invoker.sar
fi

# Removing HTTP IIOP/Corba
if [ $REMOVE_HTTP_invoker = "Y" ]; then
	debug ---------------------------------------------------------------------
	debug "Removing IIOP/Corba:"
	rejectFileOrDirectory ${JBOSS_HOME}/server/${SLIMMED_PROFILE_NAME}/conf/jacorb.properties
	rejectFileOrDirectory ${JBOSS_HOME}/server/${SLIMMED_PROFILE_NAME}/deploy/iiop-service.xml
	rejectFileOrDirectory ${JBOSS_HOME}/server/${SLIMMED_PROFILE_NAME}/deployers/ejb3.deployer/META-INF/ejb3-iiop-deployers-jboss-beans.xml
	rejectFileOrDirectory ${JBOSS_HOME}/server/${SLIMMED_PROFILE_NAME}/lib/jacorb.jar
fi

# Removing remote (RMI) access to JMX
if [ $REMOVE_remote_RMI_acces_to_JMX = "Y" ]; then
	debug ---------------------------------------------------------------------
	debug "Removing remote (RMI) access to JMX:"
	rejectFileOrDirectory ${JBOSS_HOME}/server/${SLIMMED_PROFILE_NAME}/deploy/jmx-invoker-service.xml
fi
