/* Use this file only when the install/upgrade fails to set configuration values
   In this case , you can do this manually.
   You should change manually the FieldsInConfig.xml path if it does not matches,
*/
DECLARE  @xml xml
--Convert file content to a xml variable
SET @xml = (SELECT CONVERT(xml, BulkColumn) FROM
OPENROWSET(Bulk '%programfiles%\RedHat\RhevManager\Service\FieldsInVDCConfig.xml', SINGLE_BLOB) [rowsetresults])
 
declare @version nvarchar(40)
DECLARE c1 CURSOR 
FOR
		SELECT  t.c.[value]('@name','nvarchar(40)') as Version
		FROM @xml.nodes('/Versions/Version')as t(c)
	OPEN c1

	FETCH NEXT FROM c1
	INTO @version

	WHILE @@FETCH_STATUS = 0
	BEGIN  
		-- Inserts new values added by the latest version in the xml file to the database.
		exec upgrade_insert_new_config_values @xml, @version

		/*
		Override database values with current product settings only for entries in the xml
		that are marked with the override flag. This enables force overriding a value that may be 
		already changed by the customer to a new value.
		*/
		exec upgrade_override_config_values @xml, @version

		--Cleanup any configuration variables that are no longer supported (or being renamed) by the latest version.

		exec upgrade_cleanup_config_values @xml, @version
		FETCH NEXT FROM c1
		INTO @version            
	END
	CLOSE c1
	DEALLOCATE c1	


go
