using System;
using System.Collections.Generic;
using System.Text;
using VdcCommon.BusinessEntities;

namespace SearchBackend
{
    class VdcUserConditionFieldAutoCompleter :BaseConditionFieldAutoCompleter
    {
        public VdcUserConditionFieldAutoCompleter()
            : base()
        {
            //Building the basic vervs Dict
            mVerbs.Add("NAME", "NAME");
            mVerbs.Add("LASTNAME", "LASTNAME");
            mVerbs.Add("USRNAME", "USRNAME");
            mVerbs.Add("DEPARTMENT", "DEPARTMENT");
            mVerbs.Add("GROUP", "GROUP");
            mVerbs.Add("TITLE", "TITLE");
            mVerbs.Add("STATUS", "STATUS");
            mVerbs.Add("ROLE", "ROLE");
			mVerbs.Add("TAG", "TAG");
			mVerbs.Add("POOL", "POOL");


            //Building the autoCompletion Dict
            buildCompletions();
            //Building the types dict
            TypeDictionary.Add("NAME", typeof(string));
            TypeDictionary.Add("LASTNAME",typeof(string));
            TypeDictionary.Add("USRNAME",typeof(string));
            TypeDictionary.Add("DEPARTMENT",typeof(string));
            TypeDictionary.Add("TITLE",typeof(string));
            TypeDictionary.Add("GROUP", typeof(string));
            TypeDictionary.Add("STATUS", typeof(AdRefStatus));
            TypeDictionary.Add("ROLE", typeof(string));
			TypeDictionary.Add("TAG", typeof(string));
			TypeDictionary.Add("POOL", typeof(string));

            //building the ColumnName Dict
            mColumnNameDict.Add("NAME", "name");
            mColumnNameDict.Add("LASTNAME", "surname");
            mColumnNameDict.Add("USRNAME", "username");
            mColumnNameDict.Add("DEPARTMENT", "department");
            mColumnNameDict.Add("TITLE", "role");
            mColumnNameDict.Add("GROUP", "groups");
            mColumnNameDict.Add("STATUS", "status");
            mColumnNameDict.Add("ROLE", "mla_role");
			mColumnNameDict.Add("TAG", "tag_name");
			mColumnNameDict.Add("POOL", "vm_pool_name");
            //Building the validation dict
            buildBasicValidationTable();
        }

        public override IAutoCompleter getFieldRelationshipAutoCompleter(string fieldName)
        {
			 IAutoCompleter retval;
			 switch (fieldName)
			 {
				 case "TAG":
					 retval = new StringOnlyEqualConditionRelationAutoCompleter();
					 break;
				 default:
					 retval = new StringConditionRelationAutoCompleter();
					 break;
			 }
            
            return retval;
        }

        public override IConditionValueAutoCompleter getFieldValueAutoCompleter(string fieldName)
        {
            IConditionValueAutoCompleter retval = null;
            switch (fieldName)
            {
                case "STATUS":
                    retval = new EnumValueAutoCompleter(typeof(AdRefStatus));
                    break;
                default:
                    break;
            }
            return retval;
        }

        public override void formatValue(string fieldName, ref string relations, ref string value)
        {
            switch (fieldName)
            {
                case "STATUS":
                    string tmp = value.Trim('\'');
                    if ((relations == "=") && (tmp == "1"))
                    {
                        relations = ">=";
                    }
                    if ((relations == "!=") && (tmp == "1"))
                    {
                        relations = "<";
                    }
                    break;
                default:
					base.formatValue(fieldName, ref relations, ref value);
                    break;
            }
        }

    }
    
}
