using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Reflection;
using System.Resources;
using System;

namespace org.ovirt.engine.ui.uicompat
{
	public class Translator : Dictionary<object, string>
	{
		protected static readonly Dictionary<string, Translator> cacheByClass;


		static Translator()
		{
			cacheByClass = new Dictionary<string, Translator>();
		}

		protected static Translator Create(Type eClass, TranslationStrategy strategy)
		{
            if (!cacheByClass.ContainsKey(eClass.FullName))
			{
				lock (cacheByClass)
				{
                    if (!cacheByClass.ContainsKey(eClass.FullName))
					{
						ResourceManager rm = new ResourceManager("UICommon.EnumTranslator.Enums", Assembly.GetExecutingAssembly());
						Translator translator = new Translator();
						strategy.Initialize();

						foreach (DictionaryEntry entry in rm.GetResourceSet(CultureInfo.CurrentCulture, true, true))
						{
							string key = entry.Key.ToString();
                            if (key.StartsWith(eClass.FullName) || CompareRegardlessOfNameSpace(key, eClass))
                            
							{
								int lastDotIndex = key.LastIndexOf('.');
								string resourceKey = key.Substring(lastDotIndex + 1);
								object translatedKey = strategy.GetKey(resourceKey);

								if (translatedKey != null)
								{
									translator.Add(translatedKey, entry.Value.ToString());
								}
							}
						}

                        cacheByClass.Add(eClass.FullName, translator);
					}
				}
			}

            return cacheByClass[eClass.FullName];
		}
        /// <summary>
        /// Performs enum type name comperation regardless of its location
        /// </summary>
        /// <param name="key">DictionaryEntry</param>
        /// <param name="eClass">Enum type</param>
        /// <returns>True if enum exist in etntry, otherwise false</returns>
        private static bool CompareRegardlessOfNameSpace(string key, Type eClass)
        {
            Type keyType = Type.GetType(key);

            return keyType==null?
                GetTypeNameByString(key) == eClass.Name
                :
                keyType.Name == eClass.Name;
        }      
        private static string GetTypeNameByString(string key)
        {
            string[] splitted = key.Split('.');

            return splitted!=null&&splitted.Length>=2 ?
                splitted[splitted.Length - 2]
                :
                splitted!=null ?
                    splitted[0]
                    :
                    "";
        }
	}
}