using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using org.ovirt.engine.ui.uicommon.models;
using org.ovirt.engine.ui.uicompat;
using Microsoft.Practices.Unity;
using org.ovirt.engine.ui.uicommon;
using VdcCommon.BusinessEntities;
using org.ovirt.engine.ui.uicommon.models.storage;
using org.ovirt.engine.ui.uicommon.models.configure;


namespace UI.WPFClient
{
	public partial class StorageListView
	{
		private WindowView view1;

		public new StorageListModel Model
		{
			get { return base.Model as StorageListModel; }
			set { base.Model = value; }
		}

		public StorageListView()
		{
			InitializeComponent();
		}

		protected override void ModelPropertyChanged(object sender, PropertyChangedEventArgs e)
		{
			base.ModelPropertyChanged(sender, e);

			if (e.PropertyName == "Window")
			{
				if (Model.Window != null)
				{
					if (Model.LastExecutedCommand == Model.NewDomainCommand)
					{
						view1 = TypeResolver.Instance.Resolve<StorageView>();
					}
					else if (Model.LastExecutedCommand == Model.ImportDomainCommand)
					{
						view1 = TypeResolver.Instance.Resolve<StorageView>();
					}
					else if (Model.LastExecutedCommand == Model.EditCommand)
					{
						view1 = TypeResolver.Instance.Resolve<StorageView>();
					}
					else if (Model.LastExecutedCommand == Model.RemoveCommand)
					{
						view1 = TypeResolver.Instance.Resolve<RemoveStorageView>();
					}
					else if (Model.LastExecutedCommand == Model.DestroyCommand)
					{
						view1 = TypeResolver.Instance.Resolve<DestroyStorageView>();
					}
					else
					{
						throw new NotImplementedException();
					}

					view1.Model = Model.Window;
					WindowManager.AddWindow(view1);
				}
				else
				{
					WindowManager.RemoveWindow(view1);
					view1 = null;
				}
			}
		}

		private void EditCommand_Executed(object sender, ExecutedRoutedEventArgs e)
		{
			Model.EditCommand.Execute();
		}

		private void EditCommand_CanExecute(object sender, CanExecuteRoutedEventArgs e)
		{
			e.CanExecute = Model.EditCommand.IsExecutionAllowed;
		}

		private void RemoveCommand_Executed(object sender, ExecutedRoutedEventArgs e)
		{
			Model.RemoveCommand.Execute();
		}

		private void RemoveCommand_CanExecute(object sender, CanExecuteRoutedEventArgs e)
		{
			e.CanExecute = Model.RemoveCommand.IsExecutionAllowed;
		}
	}
}
