PRINT 'Processing storages_san_sp.sql'

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'RethrowError')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].RethrowError AS RETURN')
END
GO

ALTER PROCEDURE RethrowError AS
    /* Return if there is no error information to retrieve. */
    IF ERROR_NUMBER() IS NULL
        RETURN;

    DECLARE
        @ErrorMessage    NVARCHAR(4000),
        @ErrorNumber     INT,
        @ErrorSeverity   INT,
        @ErrorState      INT,
        @ErrorLine       INT,
        @ErrorProcedure  NVARCHAR(200); 

    /* Assign variables to error-handling functions that
       capture information for RAISERROR. */

    SELECT
        @ErrorNumber = ERROR_NUMBER(),
        @ErrorSeverity = ERROR_SEVERITY(),
        @ErrorState = ERROR_STATE(),
        @ErrorLine = ERROR_LINE(),
        @ErrorProcedure = ISNULL(ERROR_PROCEDURE(), '-'); 

    /* Building the message string that will contain original
       error information. */

    SELECT @ErrorMessage = 
        N'Error %d, Level %d, State %d, Procedure %s, Line %d, ' + 
         'Message: '+ ERROR_MESSAGE(); 

    /* Raise an error: msg_str parameter of RAISERROR will contain
	   the original error information. */

    RAISERROR(@ErrorMessage, @ErrorSeverity, 1,
        @ErrorNumber,    /* parameter: original error number. */
        @ErrorSeverity,  /* parameter: original error severity. */
        @ErrorState,     /* parameter: original error state. */
        @ErrorProcedure, /* parameter: original error procedure name. */
        @ErrorLine       /* parameter: original error line number. */
        );

GO

----------------------------------------------------------------
-- [dbo].[LUNs] Table
--
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'InsertLUNs')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[InsertLUNs] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[InsertLUNs]
    @LUN_id nvarchar(50),
	@phisical_volume_id nvarchar(50) = NULL,
	@volume_group_id nvarchar(50) = NULL,
	@serial [nvarchar](max) = NULL,
	@lun_mapping int = NULL,
	@vendor_id [nvarchar](50) = NULL,
	@product_id [nvarchar](50) = NULL
AS
BEGIN
	SET NOCOUNT ON
	
	BEGIN TRY
    INSERT INTO [dbo].[LUNs] ([LUN_id], [phisical_volume_id], [volume_group_id], [serial], [lun_mapping], [vendor_id], [product_id])
	VALUES (@LUN_id, @phisical_volume_id, @volume_group_id, @serial, @lun_mapping, @vendor_id, @product_id)
    
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH
    
    SET NOCOUNT OFF
END    

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'DeleteLUN')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[DeleteLUN] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[DeleteLUN]
	 @LUN_id nvarchar(50)
AS
BEGIN
	SET NOCOUNT ON
	declare @val nvarchar(50)
	-- Get (and keep) a shared lock with "right to upgrade to exclusive"
	-- in order to force locking parent before children 
	SELECT @val = [LUN_id]
	FROM [dbo].[LUNs] WITH (UPDLOCK)
	WHERE [LUN_id]=@LUN_id

    DELETE FROM [dbo].[LUNs]
	WHERE [LUN_id]=@LUN_id
    
    SET NOCOUNT OFF
END

GO





IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetAllFromLUNs')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetAllFromLUNs] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetAllFromLUNs]    
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	
	SELECT
	[LUNs].[LUN_id] AS 'LUN_id',
	[LUNs].[phisical_volume_id] AS 'phisical_volume_id',
	[LUNs].[volume_group_id] AS 'volume_group_id',
	[LUNs].[serial] AS 'serial',
	[LUNs].[lun_mapping] AS 'lun_mapping',
	[LUNs].[vendor_id] AS 'vendor_id',
	[LUNs].[product_id] AS 'product_id'
FROM [dbo].[LUNs] [LUNs]

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetLUNsBystorage_server_connection')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetLUNsBystorage_server_connection] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetLUNsBystorage_server_connection] 
	@storage_server_connection nvarchar(50)
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	
	SELECT
	[LUNs].[LUN_id] AS 'LUN_id',
	[LUNs].[phisical_volume_id] AS 'phisical_volume_id',
    [LUNs].[volume_group_id] AS 'volume_group_id',
    [LUNs].[serial] AS 'serial',
    [LUNs].[lun_mapping] AS 'lun_mapping',
    [LUNs].[vendor_id] AS 'vendor_id',
    [LUNs].[product_id] AS 'product_id'

	FROM [dbo].[LUNs] [LUNs] INNER JOIN
                      [LUN_storage_server_connection_map]
					ON [LUN_storage_server_connection_map].[LUN_id] = [LUNs].[LUN_id]

	WHERE [LUN_storage_server_connection_map].[storage_server_connection]=@storage_server_connection

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetLUNsByVolumeGroupId')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetLUNsByVolumeGroupId] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetLUNsByVolumeGroupId] 
	@volume_group_id nvarchar(50)
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	
	SELECT
	[LUNs].[LUN_id] AS 'LUN_id',
	[LUNs].[phisical_volume_id] AS 'phisical_volume_id',
    [LUNs].[volume_group_id] AS 'volume_group_id',
    [LUNs].[serial] AS 'serial',
    [LUNs].[lun_mapping] AS 'lun_mapping',
    [LUNs].[vendor_id] AS 'vendor_id',
    [LUNs].[product_id] AS 'product_id'

	FROM [dbo].[LUNs] [LUNs]
	WHERE [volume_group_id]=@volume_group_id 

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetLUNByLUNId')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetLUNByLUNId] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetLUNByLUNId] 
	@LUN_id nvarchar(50)
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	
	SELECT
	[LUNs].[LUN_id] AS 'LUN_id',
	[LUNs].[phisical_volume_id] AS 'phisical_volume_id',
    [LUNs].[volume_group_id] AS 'volume_group_id',
    [LUNs].[serial] AS 'serial',
    [LUNs].[lun_mapping] AS 'lun_mapping',
    [LUNs].[vendor_id] AS 'vendor_id',
    [LUNs].[product_id] AS 'product_id'
	FROM [dbo].[LUNs] [LUNs]
	WHERE [LUN_id]=@LUN_id 

	SET NOCOUNT OFF
END

GO
----------------------------------------------------------------
-- [dbo].[storage_domain_dynamic] Table
--
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Insertstorage_domain_dynamic')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Insertstorage_domain_dynamic] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Insertstorage_domain_dynamic]
    @available_disk_size int = NULL,
	@id uniqueidentifier,
	@used_disk_size int = NULL
AS
BEGIN
	SET NOCOUNT ON
	
	BEGIN TRY
    INSERT INTO [dbo].[storage_domain_dynamic] ([available_disk_size], [id], [used_disk_size])
	VALUES (@available_disk_size, @id, @used_disk_size)
    
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH
    
    SET NOCOUNT OFF
END    

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Updatestorage_domain_dynamic')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Updatestorage_domain_dynamic] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Updatestorage_domain_dynamic]
    @available_disk_size int = NULL,
	@id uniqueidentifier,
	@used_disk_size int = NULL
AS
BEGIN

	--The [dbo].[storage_domain_dynamic] table doesn't have a timestamp column. Optimistic concurrency logic cannot be generated
	SET NOCOUNT ON

	BEGIN TRY
	UPDATE [dbo].[storage_domain_dynamic] 
	SET [available_disk_size] = @available_disk_size, [used_disk_size] = @used_disk_size
	WHERE [id]=@id

	IF @@ROWCOUNT = 0
	BEGIN
		RAISERROR('Concurrent update error. Updated aborted.', 16, 2)
	END
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH	

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Deletestorage_domain_dynamic')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Deletestorage_domain_dynamic] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Deletestorage_domain_dynamic]
	 @id uniqueidentifier
AS
BEGIN
	SET NOCOUNT ON
	
    DELETE FROM [dbo].[storage_domain_dynamic]
	WHERE [id]=@id
    
    SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetAllFromstorage_domain_dynamic')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetAllFromstorage_domain_dynamic] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetAllFromstorage_domain_dynamic]    
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	
	SELECT
	[storage_domain_dynamic].[available_disk_size] AS 'available_disk_size',
	[storage_domain_dynamic].[id] AS 'id',
	[storage_domain_dynamic].[used_disk_size] AS 'used_disk_size'
FROM [dbo].[storage_domain_dynamic] [storage_domain_dynamic]

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Getstorage_domain_dynamicByid')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Getstorage_domain_dynamicByid] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Getstorage_domain_dynamicByid] 
	@id uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	
	SELECT
	[storage_domain_dynamic].[available_disk_size] AS 'available_disk_size',
	[storage_domain_dynamic].[id] AS 'id',
	[storage_domain_dynamic].[used_disk_size] AS 'used_disk_size'
	FROM [dbo].[storage_domain_dynamic] [storage_domain_dynamic]
	WHERE [id]=@id

	SET NOCOUNT OFF
END

GO


--The GetByFK stored procedure cannot be created because the [dbo].[storage_domain_dynamic] table doesn't have at least one foreign key column or the foreign keys are also primary keys.

----------------------------------------------------------------
-- [dbo].[storage_pool_iso_map] Table
--
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Insertstorage_pool_iso_map')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Insertstorage_pool_iso_map] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Insertstorage_pool_iso_map]
    @storage_id uniqueidentifier,
	@storage_pool_id uniqueidentifier,
	@status int = NULL,
	@owner int = NULL
AS
BEGIN
	SET NOCOUNT ON
	
	BEGIN TRY
    INSERT INTO [dbo].[storage_pool_iso_map] ([storage_id], [storage_pool_id], [status], [owner])
	VALUES (@storage_id, @storage_pool_id, @status, @owner)
    
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH
    
    SET NOCOUNT OFF
END    

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Updatestorage_pool_iso_map')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Updatestorage_pool_iso_map] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Updatestorage_pool_iso_map]
    @storage_id uniqueidentifier,
	@storage_pool_id uniqueidentifier,
	@status int = NULL,
	@owner int = NULL
AS
BEGIN

	--The [dbo].[storage_pool_iso_map] table doesn't have a timestamp column. Optimistic concurrency logic cannot be generated
	SET NOCOUNT ON

	BEGIN TRY
	UPDATE [dbo].[storage_pool_iso_map] 
	SET [status] = @status, [owner] = @owner
	WHERE [storage_id]=@storage_id and [storage_pool_id] = @storage_pool_id

	IF @@ROWCOUNT = 0
	BEGIN
		RAISERROR('Concurrent update error. Updated aborted.', 16, 2)
	END
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH	

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Deletestorage_pool_iso_map')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Deletestorage_pool_iso_map] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Deletestorage_pool_iso_map]
	 @storage_id uniqueidentifier,
	@storage_pool_id uniqueidentifier
AS
BEGIN
	SET NOCOUNT ON
	
    DELETE FROM [dbo].[storage_pool_iso_map]
	WHERE [storage_id]=@storage_id AND [storage_pool_id]=@storage_pool_id
    
    SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetAllFromstorage_pool_iso_map')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetAllFromstorage_pool_iso_map] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetAllFromstorage_pool_iso_map]    
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	
	SELECT
	[storage_pool_iso_map].[storage_id] AS 'storage_id',
	[storage_pool_iso_map].[storage_pool_id] AS 'storage_pool_id',
	[storage_pool_iso_map].[status] AS 'status',
	[storage_pool_iso_map].[owner] AS 'owner'
FROM [dbo].[storage_pool_iso_map] [storage_pool_iso_map]

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Getstorage_pool_iso_mapBystorage_idAndBystorage_pool_id')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Getstorage_pool_iso_mapBystorage_idAndBystorage_pool_id] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Getstorage_pool_iso_mapBystorage_idAndBystorage_pool_id] 
	@storage_id uniqueidentifier,
	@storage_pool_id uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	
	SELECT
	[storage_pool_iso_map].[storage_id] AS 'storage_id',
	[storage_pool_iso_map].[storage_pool_id] AS 'storage_pool_id',
	[storage_pool_iso_map].[status] AS 'status',
	[storage_pool_iso_map].[owner] AS 'owner'
	FROM [dbo].[storage_pool_iso_map] [storage_pool_iso_map]
	WHERE [storage_id]=@storage_id AND [storage_pool_id]=@storage_pool_id

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Getstorage_pool_iso_mapsBystorage_id')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Getstorage_pool_iso_mapsBystorage_id] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Getstorage_pool_iso_mapsBystorage_id] 
	@storage_id uniqueidentifier
	
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	
	SELECT
	[storage_pool_iso_map].[storage_id] AS 'storage_id',
	[storage_pool_iso_map].[storage_pool_id] AS 'storage_pool_id',
	[storage_pool_iso_map].[status] AS 'status',
	[storage_pool_iso_map].[owner] AS 'owner'
	FROM [dbo].[storage_pool_iso_map] [storage_pool_iso_map]
	WHERE [storage_id]=@storage_id

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Getstorage_pool_iso_mapsByBystorage_pool_id')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Getstorage_pool_iso_mapsByBystorage_pool_id] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Getstorage_pool_iso_mapsByBystorage_pool_id] 
	@storage_id uniqueidentifier,
	@storage_pool_id uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	
	SELECT
	[storage_pool_iso_map].[storage_id] AS 'storage_id',
	[storage_pool_iso_map].[storage_pool_id] AS 'storage_pool_id',
	[storage_pool_iso_map].[status] AS 'status',
	[storage_pool_iso_map].[owner] AS 'owner'
	FROM [dbo].[storage_pool_iso_map] [storage_pool_iso_map]
	WHERE [storage_pool_id]=@storage_pool_id

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Updatestorage_pool_iso_map_status')
BEGIN
        EXEC('CREATE PROCEDURE [dbo].[Updatestorage_pool_iso_map_status] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Updatestorage_pool_iso_map_status]
    @storage_id uniqueidentifier,
    @storage_pool_id uniqueidentifier,
    @status int
AS
BEGIN

        UPDATE [dbo].[storage_pool_iso_map]
        SET [status] = @status
        WHERE [storage_id]=@storage_id AND [storage_pool_id]=@storage_pool_id

END

GO

--The GetByFK stored procedure cannot be created because the [dbo].[storage_pool_iso_map] table doesn't have at least one foreign key column or the foreign keys are also primary keys.

----------------------------------------------------------------
-- [dbo].[storage_server_connections] Table
--
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Insertstorage_server_connections')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Insertstorage_server_connections] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Insertstorage_server_connections]
    @connection nvarchar(250),
	@id nvarchar(50),
	@iqn nvarchar(128) = NULL,
	@port [nvarchar](50) = NULL,
	@portal [nvarchar](50) = NULL,
	@password nvarchar(50) = NULL,
	@storage_type int,
	@user_name nvarchar(50) = NULL
AS
BEGIN
	SET NOCOUNT ON
	
	BEGIN TRY
    INSERT INTO [dbo].[storage_server_connections] ([connection], [id], [iqn], [port],[portal],
	[password], [storage_type], [user_name])
	VALUES (@connection, @id, @iqn,@port,@portal, @password, @storage_type, @user_name)
    
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH
    
    SET NOCOUNT OFF
END    

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Updatestorage_server_connections')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Updatestorage_server_connections] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Updatestorage_server_connections]
    @connection nvarchar(250),
	@id nvarchar(50),
	@iqn nvarchar(128) = NULL,
	@password nvarchar(50) = NULL,
	@storage_type int,
	@port [nvarchar](50) = NULL,
	@portal [nvarchar](50) = NULL,
	@user_name nvarchar(50) = NULL
AS
BEGIN

	--The [dbo].[storage_server_connections] table doesn't have a timestamp column. Optimistic concurrency logic cannot be generated
	SET NOCOUNT ON

	BEGIN TRY
	UPDATE [dbo].[storage_server_connections] 
	SET [connection] = @connection, [iqn] = @iqn, [password] = @password, [port] = @port, [portal] =@portal,
	[storage_type] = @storage_type, [user_name] = @user_name
	WHERE [id]=@id

	IF @@ROWCOUNT = 0
	BEGIN
		RAISERROR('Concurrent update error. Updated aborted.', 16, 2)
	END
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH	

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Deletestorage_server_connections')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Deletestorage_server_connections] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Deletestorage_server_connections]
	 @id nvarchar(50)
AS
BEGIN
	SET NOCOUNT ON
	declare @val nvarchar(50)
	-- Get (and keep) a shared lock with "right to upgrade to exclusive"
	-- in order to force locking parent before children 
	SELECT @val = [id]
	FROM [dbo].[storage_server_connections] WITH (UPDLOCK)
	WHERE [id]=@id
	
    DELETE FROM [dbo].[storage_server_connections]
	WHERE [id]=@id
    
    SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetAllFromstorage_server_connections')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetAllFromstorage_server_connections] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetAllFromstorage_server_connections]    
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	
	SELECT
	[storage_server_connections].[connection] AS 'connection',
	[storage_server_connections].[id] AS 'id',
	[storage_server_connections].[iqn] AS 'iqn',
	[storage_server_connections].[port] AS 'port',
	[storage_server_connections].[portal] AS 'portal',
	[storage_server_connections].[password] AS 'password',
	[storage_server_connections].[storage_type] AS 'storage_type',
	[storage_server_connections].[user_name] AS 'user_name'
FROM [dbo].[storage_server_connections] [storage_server_connections]

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Getstorage_server_connectionsByid')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Getstorage_server_connectionsByid] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Getstorage_server_connectionsByid] 
	@id nvarchar(50)
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	
	SELECT
	[storage_server_connections].[connection] AS 'connection',
	[storage_server_connections].[id] AS 'id',
	[storage_server_connections].[iqn] AS 'iqn',
	[storage_server_connections].[port] AS 'port',
	[storage_server_connections].[portal] AS 'portal',
	[storage_server_connections].[password] AS 'password',
	[storage_server_connections].[storage_type] AS 'storage_type',
	[storage_server_connections].[user_name] AS 'user_name'
	FROM [dbo].[storage_server_connections] [storage_server_connections]
	WHERE [id]=@id

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Getstorage_server_connectionsByConnection')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Getstorage_server_connectionsByConnection] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Getstorage_server_connectionsByConnection] 
	@connection nvarchar(250)
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	
	SELECT
	[storage_server_connections].[connection] AS 'connection',
	[storage_server_connections].[id] AS 'id',
	[storage_server_connections].[iqn] AS 'iqn',
	[storage_server_connections].[port] AS 'port',
	[storage_server_connections].[portal] AS 'portal',
	[storage_server_connections].[password] AS 'password',
	[storage_server_connections].[storage_type] AS 'storage_type',
	[storage_server_connections].[user_name] AS 'user_name'
	FROM [dbo].[storage_server_connections] [storage_server_connections]
	WHERE [connection]=@connection

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Getstorage_server_connectionsByIqn')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Getstorage_server_connectionsByIqn] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Getstorage_server_connectionsByIqn] 
	@iqn nvarchar(128)
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	
	SELECT
	[storage_server_connections].[connection] AS 'connection',
	[storage_server_connections].[id] AS 'id',
	[storage_server_connections].[iqn] AS 'iqn',
	[storage_server_connections].[port] AS 'port',
	[storage_server_connections].[portal] AS 'portal',
	[storage_server_connections].[password] AS 'password',
	[storage_server_connections].[storage_type] AS 'storage_type',
	[storage_server_connections].[user_name] AS 'user_name'
	FROM [dbo].[storage_server_connections] [storage_server_connections]
	WHERE [iqn]=@iqn

	SET NOCOUNT OFF
END

GO
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Getstorage_server_connectionsByIqnAndConnection')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Getstorage_server_connectionsByIqnAndConnection] AS RETURN')
END

GO
ALTER PROCEDURE [dbo].[Getstorage_server_connectionsByIqnAndConnection] 
	@iqn nvarchar(128) = NULL,
	@connection nvarchar(250)
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	
	SELECT
	[storage_server_connections].[connection] AS 'connection',
	[storage_server_connections].[id] AS 'id',
	[storage_server_connections].[iqn] AS 'iqn',
	[storage_server_connections].[port] AS 'port',
	[storage_server_connections].[portal] AS 'portal',
	[storage_server_connections].[password] AS 'password',
	[storage_server_connections].[storage_type] AS 'storage_type',
	[storage_server_connections].[user_name] AS 'user_name'
	FROM [dbo].[storage_server_connections] [storage_server_connections]
	WHERE [iqn]=@iqn and ([connection] = @connection or [connection] is NULL)

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Getstorage_server_connectionsByKey')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Getstorage_server_connectionsByKey] AS RETURN')
END

GO
ALTER PROCEDURE [dbo].[Getstorage_server_connectionsByKey] 
	@iqn nvarchar(128) = NULL,
	@connection nvarchar(250),
	@port nvarchar(50) = NULL,
	@portal nvarchar(50) = NULL,
	@username nvarchar(50) = NULL,
	@password nvarchar(50) = NULL
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	
	SELECT
	[storage_server_connections].[connection] AS 'connection',
	[storage_server_connections].[id] AS 'id',
	[storage_server_connections].[iqn] AS 'iqn',
	[storage_server_connections].[port] AS 'port',
	[storage_server_connections].[portal] AS 'portal',
	[storage_server_connections].[password] AS 'password',
	[storage_server_connections].[storage_type] AS 'storage_type',
	[storage_server_connections].[user_name] AS 'user_name'
	FROM [dbo].[storage_server_connections] [storage_server_connections]
	WHERE ([iqn]=@iqn or [iqn] is NULL) and 
			([connection] = @connection) and
			([port] = @port or [port] is NULL) and
			([portal] = @portal or [portal] is NULL) and
			([user_name] = @username or [user_name] is NULL) and
			([password] = @password or [password] is NULL)

	SET NOCOUNT OFF
END

GO
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Getstorage_server_connectionsByStorageType')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Getstorage_server_connectionsByStorageType] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Getstorage_server_connectionsByStorageType] 
	@storage_type int
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	
	SELECT
	[storage_server_connections].[connection] AS 'connection',
	[storage_server_connections].[id] AS 'id',
	[storage_server_connections].[iqn] AS 'iqn',
	[storage_server_connections].[port] AS 'port',
	[storage_server_connections].[portal] AS 'portal',
	[storage_server_connections].[password] AS 'password',
	[storage_server_connections].[storage_type] AS 'storage_type',
	[storage_server_connections].[user_name] AS 'user_name'
	FROM [dbo].[storage_server_connections] [storage_server_connections]
	WHERE [storage_type]=@storage_type

	SET NOCOUNT OFF
END

GO
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Getstorage_server_connectionsByVolumeGroupId')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Getstorage_server_connectionsByVolumeGroupId] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Getstorage_server_connectionsByVolumeGroupId] 
	@volume_group_id nvarchar(50)
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	
	SELECT distinct
	[storage_server_connections].[connection] AS 'connection',
	[storage_server_connections].[id] AS 'id',
	[storage_server_connections].[iqn] AS 'iqn',
	[storage_server_connections].[port] AS 'port',
	[storage_server_connections].[portal] AS 'portal',
	[storage_server_connections].[password] AS 'password',
	[storage_server_connections].[storage_type] AS 'storage_type',
	[storage_server_connections].[user_name] AS 'user_name'
FROM         
 dbo.LUN_storage_server_connection_map INNER JOIN
                      dbo.LUNs ON dbo.LUN_storage_server_connection_map.LUN_id = dbo.LUNs.LUN_id INNER JOIN
                      dbo.storage_domain_static ON dbo.LUNs.volume_group_id = dbo.storage_domain_static.storage INNER JOIN
                      dbo.storage_server_connections ON 
                      dbo.LUN_storage_server_connection_map.storage_server_connection = dbo.storage_server_connections.id
WHERE     (dbo.storage_domain_static.storage = @volume_group_id)
SET NOCOUNT OFF
END
GO
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Getstorage_server_connectionsByStoragePoolId')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Getstorage_server_connectionsByStoragePoolId] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Getstorage_server_connectionsByStoragePoolId] 
	@storage_pool_id uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	
	SELECT distinct
	[storage_server_connections].[connection] AS 'connection',
	[storage_server_connections].[id] AS 'id',
	[storage_server_connections].[iqn] AS 'iqn',
	[storage_server_connections].[port] AS 'port',
	[storage_server_connections].[portal] AS 'portal',
	[storage_server_connections].[password] AS 'password',
	[storage_server_connections].[storage_type] AS 'storage_type',
	[storage_server_connections].[user_name] AS 'user_name'
FROM         
dbo.LUN_storage_server_connection_map 
		INNER JOIN  dbo.LUNs ON dbo.LUN_storage_server_connection_map.LUN_id = dbo.LUNs.LUN_id 
		INNER JOIN  dbo.storage_domains ON dbo.LUNs.volume_group_id = dbo.storage_domains.storage 
		INNER JOIN  dbo.storage_server_connections ON dbo.LUN_storage_server_connection_map.storage_server_connection = dbo.storage_server_connections.id
WHERE     (dbo.storage_domains.storage_pool_id = @storage_pool_id  and dbo.storage_domains.status in (0,3))
UNION
SELECT     distinct 
dbo.storage_server_connections.connection, 
dbo.storage_server_connections.id,
dbo.storage_server_connections.iqn, 
[storage_server_connections].[port] AS 'port',
[storage_server_connections].[portal] AS 'portal',
dbo.storage_server_connections.password, 
dbo.storage_server_connections.storage_type,
dbo.storage_server_connections.user_name 
FROM         dbo.storage_server_connections 
				INNER JOIN  dbo.storage_domains ON dbo.storage_server_connections.id = dbo.storage_domains.storage
WHERE     (dbo.storage_domains.storage_pool_id = @storage_pool_id and dbo.storage_domains.status in (0,3))
SET NOCOUNT OFF
END

GO
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetNFSstorage_server_connectionsByStoragePoolId')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetNFSstorage_server_connectionsByStoragePoolId] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetNFSstorage_server_connectionsByStoragePoolId] 
	@storage_pool_id uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	
	SELECT distinct
	[storage_server_connections].[connection] AS 'connection',
	[storage_server_connections].[id] AS 'id',
	[storage_server_connections].[iqn] AS 'iqn',
	[storage_server_connections].[port] AS 'port',
	[storage_server_connections].[portal] AS 'portal',
	[storage_server_connections].[password] AS 'password',
	[storage_server_connections].[storage_type] AS 'storage_type',
	[storage_server_connections].[user_name] AS 'user_name'

FROM    dbo.storage_server_connections INNER JOIN
        dbo.storage_domain_static_view ON 
				dbo.storage_server_connections.id = dbo.storage_domain_static_view.storage
WHERE     (dbo.storage_domain_static_view.storage_pool_id = @storage_pool_id )
SET NOCOUNT OFF
END
GO
--The GetByFK stored procedure cannot be created because the [dbo].[storage_server_connections] table doesn't have at least one foreign key column or the foreign keys are also primary keys.


IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'RethrowError')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].RethrowError AS RETURN')
END
GO

ALTER PROCEDURE RethrowError AS
    /* Return if there is no error information to retrieve. */
    IF ERROR_NUMBER() IS NULL
        RETURN;

    DECLARE
        @ErrorMessage    NVARCHAR(4000),
        @ErrorNumber     INT,
        @ErrorSeverity   INT,
        @ErrorState      INT,
        @ErrorLine       INT,
        @ErrorProcedure  NVARCHAR(200); 

    /* Assign variables to error-handling functions that
       capture information for RAISERROR. */

    SELECT
        @ErrorNumber = ERROR_NUMBER(),
        @ErrorSeverity = ERROR_SEVERITY(),
        @ErrorState = ERROR_STATE(),
        @ErrorLine = ERROR_LINE(),
        @ErrorProcedure = ISNULL(ERROR_PROCEDURE(), '-'); 

    /* Building the message string that will contain original
       error information. */

    SELECT @ErrorMessage = 
        N'Error %d, Level %d, State %d, Procedure %s, Line %d, ' + 
         'Message: '+ ERROR_MESSAGE(); 

    /* Raise an error: msg_str parameter of RAISERROR will contain
	   the original error information. */

    RAISERROR(@ErrorMessage, @ErrorSeverity, 1,
        @ErrorNumber,    /* parameter: original error number. */
        @ErrorSeverity,  /* parameter: original error severity. */
        @ErrorState,     /* parameter: original error state. */
        @ErrorProcedure, /* parameter: original error procedure name. */
        @ErrorLine       /* parameter: original error line number. */
        );

GO

----------------------------------------------------------------
-- [dbo].[LUN_storage_server_connection_map] Table
--
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'InsertLUN_storage_server_connection_map')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[InsertLUN_storage_server_connection_map] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[InsertLUN_storage_server_connection_map]
    @lUN_id nvarchar(50),
	@storage_server_connection nvarchar(50)
AS
BEGIN
	SET NOCOUNT ON
	
	BEGIN TRY
    INSERT INTO [dbo].[LUN_storage_server_connection_map] ([LUN_id], [storage_server_connection])
	VALUES (@lUN_id, @storage_server_connection)
    
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH
    
    SET NOCOUNT OFF
END    

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'UpdateLUN_storage_server_connection_map')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[UpdateLUN_storage_server_connection_map] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[UpdateLUN_storage_server_connection_map]
    @lUN_id nvarchar(50),
	@storage_server_connection nvarchar(50)
AS
BEGIN

	--The [dbo].[LUN_storage_server_connection_map] table doesn't have a timestamp column. Optimistic concurrency logic cannot be generated
	SET NOCOUNT ON

	BEGIN TRY
	

	IF @@ROWCOUNT = 0
	BEGIN
		RAISERROR('Concurrent update error. Updated aborted.', 16, 2)
	END
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH	

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'DeleteLUN_storage_server_connection_map')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[DeleteLUN_storage_server_connection_map] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[DeleteLUN_storage_server_connection_map]
	 @lUN_id nvarchar(50),
	@storage_server_connection nvarchar(50)
AS
BEGIN
	SET NOCOUNT ON
	
    DELETE FROM [dbo].[LUN_storage_server_connection_map]
	WHERE [LUN_id]=@lUN_id AND [storage_server_connection]=@storage_server_connection
    
    SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetAllFromLUN_storage_server_connection_map')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetAllFromLUN_storage_server_connection_map] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetAllFromLUN_storage_server_connection_map]    
AS
BEGIN
	SET NOCOUNT ON
	
	SELECT
	[lUN_storage_server_connection_map].[LUN_id] AS 'LUN_id',
	[lUN_storage_server_connection_map].[storage_server_connection] AS 'storage_server_connection'
FROM [dbo].[LUN_storage_server_connection_map] [lUN_storage_server_connection_map]

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetLUN_storage_server_connection_mapByLUNBystorage_server_conn')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetLUN_storage_server_connection_mapByLUNBystorage_server_conn] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetLUN_storage_server_connection_mapByLUNBystorage_server_conn] 
	@lUN_id nvarchar(50),
	@storage_server_connection nvarchar(50)
AS
BEGIN

	SET NOCOUNT ON
	
	SELECT
	[lUN_storage_server_connection_map].[LUN_id] AS 'LUN_id',
	[lUN_storage_server_connection_map].[storage_server_connection] AS 'storage_server_connection'
	FROM [dbo].[LUN_storage_server_connection_map] [lUN_storage_server_connection_map]
	WHERE [LUN_id]=@lUN_id AND [storage_server_connection]=@storage_server_connection

	SET NOCOUNT OFF
END

GO


