package org.ovirt.engine.core.ldap;

import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

public class RootDSEUtil {

    private RootDSEUtil() {
    }

    public static Attributes getRootDSEAttributes(DirContext dirContext) throws NamingException {
        // Queries the rootDSE and get the "defaultNamingContext" attribute value -
        // this attribute will be a part of the LDAP URL to perform users queries (i.e - search for a user)
        SearchControls controls = RootDSEQueryInfo.createSearchControls();
        String query = RootDSEQueryInfo.ROOT_DSE_LDAP_QUERY;
        Attributes attributes = new BasicAttributes(true);
        NamingEnumeration<SearchResult> results = dirContext.search("", query, controls);
        while (results.hasMoreElements()) {
             NamingEnumeration<? extends Attribute> all = results.next().getAttributes().getAll();
             while (all.hasMoreElements()) {
                 attributes.put(all.next());
             }
        }
        return attributes;
    }

    public static String getDomainDN(Attributes attributes) throws NamingException {
        // The information on base DN is located in the attribute "defaultNamingContext"
        Attribute attribute = attributes.get(RootDSEQueryInfo.DEFAULT_NAMING_CONTEXT_RESULT_ATTRIBUTE);
        if (attribute != null) {
            return (String) attribute.get();
        } else {
            attribute = attributes.get(RootDSEQueryInfo.NAMING_CONTEXTS_RESULT_ATTRIBUTE);
            if (attribute != null) {
                return (String) attribute.get(0);
            }
        }
        return null;
    }

    public static boolean isIpa(Attributes attributes) {
        return attributes.get("domainControllerFunctionality") == null; // its IPA - only Active Directory server has
    } // such attribute
}
