﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Shapes;
using System.Collections.Specialized;

namespace UI.WPFClient
{
	public abstract class Chart : Control
	{
		#region Properties

		public ChartContainer Container
		{
			get { return (ChartContainer)GetValue(ContainerProperty); }
			set { SetValue(ContainerProperty, value); }
		}
		public static readonly DependencyProperty ContainerProperty =
			DependencyProperty.Register("Container", typeof(ChartContainer), typeof(Chart), new UIPropertyMetadata(null, ContainerChanged));

		private static void ContainerChanged(DependencyObject d, DependencyPropertyChangedEventArgs e)
		{
			Chart instance = (Chart)d;
			instance.ContainerChanged();
		}

		#endregion

		protected virtual void ContainerChanged()
		{
			Container.RegisterChart(this);
		}
	}
}
