#!/bin/sh

die () {
        printf >&2 "$@"
        exit 1
}

usage () {
        printf "test-manifest.sh- validate manifest file relevance.\n"
        printf "USAGE:\n"
        printf "\ttest-manifest  [csv] [ear] [root] [wlist] [-repo] [-settings] [-debug]\n"
        printf "\tie- test-manifest.sh manifest-3.2.csv ../ear/target/rhevm ../ whitelist.txt\n"
        printf "Where:\n"
        printf "\tcsv	= Path to manifest file.\n"
        printf "\tear	= Path to EAR folder\n"
        printf "\troot	= Path to project root folder\n"
        printf "\twlist	= Path to whitelist file.\n"
        printf "\trepo	= Path to external mvn repo folder\n"
        printf "\tsettings	= Path to external mvn settings file\n"
        printf "\t-debug	= Show ugly message (optional)\n"
        return 0
}

if [ "$#" -lt 6 ]; then
        usage
        die "Error: wrong argument number: $#.\n"
fi

if [ -z "$7" ]; then
  debug=""
else
  debug="$7"
fi


[ -s "$1" ] || die "Manifest file $1 does not exist\n"
[ -d "$2" ] || die "EAR folder $2 does not exist!\n"
[ -d "$3" ] || die "Root folder $3 does not exist\n"

if [ ! -s ManifestUtil.class ]; then
        javac ManifestUtil.java
fi

echo "$5"
echo "$6"

echo "$7"
java ManifestUtil -csv=$1 -ear=$2 -root=$3 -wlist=$4 $5 $6 $7
exit $?

