
%define release_version 1

Name: rhev-agent
Version: 2.3.13
Release: %{release_version}%{?dist}
Summary: RHEV Guest Agent
Group: Applications/System
License: GPLv2+
URL: http://git.engineering.redhat.com/git/users/bazulay/rhev-agent.git
Source0: %{name}-%{version}.tar.bz2
BuildArch: noarch
BuildRoot: %(mktemp -ud %{_tmppath}/%{name}-%{version}-%{release}-XXXXXX)
BuildRequires: python redhat-rpm-config
Requires: python dbus-python rpm-python SysVinit
Requires: python-ethtool
Requires: udev >= 095-14.23
Requires: kernel > 2.6.18-238.5.0
Requires: usermode

%description
This is the RHEV Management agent running inside the Guest. The agent
interfaces with the RHEV Manager, supplying heart-beat info as well as
runtime data from within the Guest itself. The agent also accepts
control commands to be run executed within the OS (like: shutdown and
restart).

%prep
%setup -q

%install
[ -n "$RPM_BUILD_ROOT" -a "$RPM_BUILD_ROOT" != / ] && rm -rf $RPM_BUILD_ROOT

make -C rhev-agent -f Makefile.el5 install DESTDIR=$RPM_BUILD_ROOT

mkdir -p $RPM_BUILD_ROOT%{_localstatedir}/log/%{name}
mkdir -p $RPM_BUILD_ROOT%{_localstatedir}/run/%{name}
mkdir -p $RPM_BUILD_ROOT%{_localstatedir}/lock/subsys/%{name}

%clean
[ -n "$RPM_BUILD_ROOT" -a "$RPM_BUILD_ROOT" != / ] && rm -rf $RPM_BUILD_ROOT

%pre
getent passwd rhevagent > /dev/null || /usr/sbin/useradd -u 175 -o -r rhevagent -c "RHEV Agent" -d / -s /sbin/nologin

%post

%define _agent_pid %{_localstatedir}/run/%{name}/rhev-agentd.pid

sed -i "s~RHEV_AGENT_CONFIG\s*=\s*[^\n]*~RHEV_AGENT_CONFIG = '%{_sysconfdir}/rhev-agent.conf'~" %{_datadir}/%{name}/rhev-agentd.py
sed -i "s~RHEV_AGENT_PIDFILE\s*=\s*[^\n]*~RHEV_AGENT_PIDFILE = '%{_agent_pid}'~" %{_datadir}/%{name}/rhev-agentd.py
sed -i "s~^pidfile=[^\n]*~pidfile=%{_agent_pid}~" %{_sysconfdir}/init.d/rhev-agentd

ln -s /usr/bin/consolehelper %{_datadir}/%{name}/rhev-shutdown

/sbin/chkconfig --add rhev-agentd

%preun
if [ "$1" -eq 0 ]
then
    /sbin/service rhev-agentd stop > /dev/null 2>&1
    /sbin/chkconfig --del rhev-agentd

    # Send an "uninstalled" notification to vdsm.
    VIRTIO=`grep "^device" %{_sysconfdir}/rhev-agent.conf | awk '{ print $3; }'`
    if [ -w $VIRTIO ]
    then
        echo '{ "__name__" : "uninstalled" }' >> $VIRTIO
    fi
fi

%postun
rm -f %{_datadir}/%{name}/rhev-shutdown

%files
%defattr(-,root,root,-)
%dir %attr (755,rhevagent,rhevagent) %{_localstatedir}/log/%{name}
%dir %attr (755,rhevagent,rhevagent) %{_localstatedir}/run/%{name}
%dir %attr (755,rhevagent,rhevagent) %{_localstatedir}/lock/subsys/%{name}
%dir %attr (755,root,root) %{_datadir}/%{name}
%config %{_sysconfdir}/rhev-agent.conf
%{_sysconfdir}/security/console.apps/rhev-shutdown
%{_sysconfdir}/pam.d/rhev-shutdown
%attr (644,root,root) %{_sysconfdir}/udev/rules.d/55-rhev-agent.rules
%attr (755,root,root) %{_sysconfdir}/init.d/rhev-agentd
%attr (755,root,root) %{_datadir}/%{name}/rhev-agentd.py*
%{_datadir}/%{name}/vdsAgentLogic.py*
%{_datadir}/%{name}/VirtIoChannel.py*
%{_datadir}/%{name}/qGuestAgentLinux2.py*
%{_datadir}/%{name}/utils.py*

%doc AUTHORS COPYING NEWS README

%changelog
* Thu Sep 15 2011 Gal Hammer <ghammer@redhat.com> - 2.3.13-1
- report new network interaces information (ipv4, ipv6 and
  mac address).
- added disks usage report.
- a new json-based protocol with the vdsm.
Resolves: BZ#729252 BZ#736426

* Mon Aug  8 2011 Gal Hammer <ghammer@redhat.com> - 2.3.12-1
- replaced password masking with a fixed-length string.
Resolves: BZ#727506

* Thu Aug  4 2011 Gal Hammer <ghammer@redhat.com> - 2.3.11-1
- send an 'uninstalled' notification to vdsm
- mask the user's password in the credentials block
Resolves: BZ#727647 BZ#727506

* Mon Jul 25 2011 Gal Hammer <ghammer@redhat.com> - 2.3.10-1
- various fixes after failing the errata's rpmdiff.
Resolves: BZ#720144

* Thu Jun 16 2011 Gal Hammer <ghammer@redhat.com> - 2.3.9-1
- read report rate values from configuration file.
- replaced executing privilege commands from sudo to
  consolehelper.
Resolves: BZ#713079 BZ#632959

* Tue Jun 14 2011 Gal Hammer <ghammer@redhat.com> - 2.3.8-1
- execute the agent with a non-root user.
- changed the shutdown timeout value to work in minutes.
Resolves: BZ#632959 BZ#711428

* Tue May 25 2011 Gal Hammer <ghammer@redhat.com> - 2.3.7-1
- show only network interfaces that are up and running.
Resolves: BZ#704845

* Thu Mar 10 2011 Gal Hammer <ghammer@redhat.com> - 2.3.4-1
- added some sleep-ing to init script in order to give udev
  some time to create the symbolic links.
- changed the kernel version condition.
Resolves: BZ#676625 BZ#681527

* Wed Mar 2 2011 Gal Hammer <ghammer@redhat.com> - 2.3.3-1
- removed unused file (rhevcredserver) from rhel-5 build.
- added udev and kernel minimum version requirment.
- fixed pid file location in spec file.
Resolves: BZ#681524 BZ#681527 BZ#681533

* Tue Mar 1 2011 Gal Hammer <ghammer@redhat.com> - 2.3.2-1
- updated the agent's makefile to work with auto-tools.
- added sub packages to support the single-sign-on feature.
- added -h parameter to shutdown command in order to halt the vm
  after shutdown.
- converted configuration file to have unix-style line ending.
- added redhat-rpm-config to build requirements in order to
  include *.pyc and *.pyo in the rpm file.
Resolves: BZ#680107 BZ#661713 BZ#679470 BZ#679451

* Wed Jan 19 2011 Gal Hammer <ghammer@redhat.com> - 2.3-7
- fixed files' mode to include execution flag.
Resolves: BZ#670476

* Mon Jan 17 2011 Gal Hammer <ghammer@redhat.com> - 2.3-6
- fixed the way the exit code was returned. the script always
  return 0 (success) because the main program ended and errors
  from the child process were lost.
Resolves: BZ#658092

* Thu Dec 23 2010 Gal Hammer <ghammer@redhat.com> - 2.3-5
- added description to startup/shutdown script in order to support
  chkconfig.
- a temporary fix to the 100% cpu usage when the vdsm doesn't
  listen to the virtio-serial.
Resolves: BZ#639702

* Sun Dec 19 2010 Gal Hammer <ghammer@redhat.com> - 2.3-4
- BZ#641886: lock command now handle both gnome and kde.
Resolves: BZ#641886

* Tue Dec 07 2010 Barak Azulay <bazulay@redhat.com> - 2.3-3
- BZ#660343 load virtio_console module before starting the daemon.
- BZ#660231 register daemon for startup.
Resolves: BZ#660343 BZ#660231

* Wed Dec 05 2010 Barak Azulay <bazulay@redhat.com> - 2.3-2
- initial build for RHEL-6
- works over vioserial 
- Agent reports only heartbeats, IPs, app list
- performs: shutdown & lock (the lock works only on gnome - when 
  ConsoleKit & gnome-screensaver is installed)
Resolves: BZ#613059
  
* Thu Aug 27 2010 Gal Hammer <ghammer@redhat.com> - 2.3-1
- Initial build.
