/**********************************************************************
 *                                                                    *
 * LOGOFF.C, version 0.1                                              *
 *                                                                    *
 * This program for Windows NT logs off the user who initiates it.    *
 * Behavior is the same as if the user clicks                         *
 * Start -> Shut Down... -> Close all programs and log on			  *
 *                          as a different user?                      *
 * except that non-responding tasks or DOS windows will be forced     *
 * to close (due to the EWX_FORCE switch in ExitWindowsEx).           *
 * It is designed to accompany INITLO, which initializes a log off    *
 * from the SYSTEM account, which displays a warning message box      *
 * before log off. If the user does not close it, the box will        *
 * remain visible indefinitely. Therefore LOGOFF looks for this       *
 * window (with title 'System Message') and sends a WM_CLOSE message  *
 * to it.                                                             *
 *                                                                    *
 * Copyright (C) 1997 by Alexander Frink                              *
 *                       Hermann Schauss Str. 8                       *
 *                       65232 Taunusstein                            *
 *                       Germany                                      *
 *                       Alexander.Frink@Uni-Mainz.DE                 *
 *                                                                    *
 * This program is free software; you can redistribute it and/or      *
 * modify it under the terms of the GNU General Public License        * 
 * as published by the Free Software Foundation; either version 2     *
 * of the License, or (at your option) any later version.             *
 *                                                                    *
 * This program is distributed in the hope that it will be useful,    *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of     *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the       *
 * GNU General Public License (file name: LICENSE) for more details.  *
 *                                                                    *
 * You should have received a copy of the GNU General Public License  * 
 * along with this program; if not, write to the Free Software        *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.          *
 *                                                                    *
 **********************************************************************/

#include <windows.h>
#include <stdio.h>

// FILE *out;

BOOL CALLBACK ListWindows(HWND hWnd, LPARAM lparam)
{
    UCHAR szTitle[1024];
    GetWindowText(hWnd,szTitle,1024);
    if (strcmp(szTitle,"System Message")==0) {
        PostMessage(hWnd,WM_CLOSE,0,0);
    }
//    fprintf(out,"title %s\n",szTitle);
    return TRUE;
}

int main(void)
{
    ExitWindowsEx(EWX_LOGOFF | EWX_FORCE,0);

//    out=fopen("c:\\temp\\logoff.log","w");
    EnumWindows(ListWindows,0);
//    fclose(out);

    return 0;
}