function CanRegRead(type,key,name)
//--#Test if RegRead can work. Returns null on OK, a string when there are problems.
//--@type;type=string@The type of the registry value
//--@key;type=string@not used. The first part of the the key
//--@name;type=string@The final key name.
{
 if(name!=null && name.indexOf('\\')!=-1) {
  return 'Can\'t read entries with a back-slash in the name.';
 }
 switch(type) {
  case 'REG_NONE':
  case 'REG_DWORD_LITTLE_ENDIAN':
  case 'REG_LINK':
  case 'REG_RESOURCE_LIST':
  case 'REG_FULL_RESOURCE_DESCRIPTOR':
  case 'REG_RESOURCE_REQUIREMENT_LIST':
  case 'REG_QWORD':
   return 'Type '+type+' is unsupported by RegRead';
  case 'REG_DWORD':
  case 'REG_BINARY':
  case 'REG_SZ':
  case 'REG_EXPAND_SZ':
  case 'REG_MULTI_SZ':
   return null; //OK
  default:
   return 'Type type '+type+' is not recognized at all';
 }
}

function RegRead(key,name)
//--#Read the key from the registry, and return it in a javascript-friendly format.
//--@key;type=string@The first part of the the key
//--@name;type=string@The final key name.
//--@returns@Null if not found, or the value in a javascript-friendly format.
{
	var wsh;

	// Get WSH Object
	wsh = WScript.CreateObject("WScript.Shell");

	if(name==null) {
		name=key+'\\';
	} else {
		name=key+'\\'+name;
	}

	try {
		var item=wsh.regRead(name);
	} catch(ex) {
		if(2==(ex.number&0xFFFF)) {
			return null; //Not found
		}

		WScript.Echo ('Unknown exception, rethowing #'+(ex.number&0xFFFF)+': '+ex.description);
		LogEvent ('Unknown exception, rethowing #'+(ex.number&0xFFFF)+': '+ex.description);
		throw ex; //unknown error
	}

	if(typeof item=='string') {
		if(name.substr(name.length-1)=='\\') {
			var indexOfNameInItem=item.indexOf(name);
			if(indexOfNameInItem!=-1 && indexOfNameInItem==item.length-name.length) {
				//when querying for default values, the keyname is sometimes appended to the value (within clsid branch most times)
    				return item.substring(0,item.length-name.length);
   			}
  		}
  		return item; //REG_SZ or REG_EXPAND_SZ
 	}

	if(typeof item=='number') {
		//REG_DWORD
		if(item<0) {
			//there are some problems with dwords with some high bits set...
			return eval('0x'+ (item>>>8).toString(16)+((item&0xff)<=0xf?'0':'')+(item&0xff).toString(16));
		} else {
   			return item; 
		}
	}

	if(typeof item=='unknown') {
		return new VBArray(item).toArray(); //REG_BINARY or REG_MULTI_SZ
	}

	throw new Error(0x07b4,'Unexpected javascript type "'+typeof item+'" read from registry item "'+name+'"');
}