@ECHO OFF

REM use INTERNAL=0 only when calling from .Net otherwise INTERNAL=1 should be used
REM when running from .Net the script exit code is not retrned to the caller if /B switch was used
IF "%2" == "1" (
	set INTERNAL=/B
) else (
	set INTERNAL=""
)

setlocal enableextensions

IF (%6)==() GOTO Usage

REM handling Program Files
set JV_HOME=%JAVA_HOME:Program Files (x86)=PROGRA~2%
set JV_HOME=%JAVA_HOME:Program Files=PROGRA~1%

set MY_JAVA=java
set MY_KEYTOOL=keytool
"%MY_JAVA%" -help >NUL 2>&1 || set MY_JAVA=%JV_HOME%\bin\java
"%MY_JAVA%" -help >NUL 2>&1 || GOTO noJava
"%MY_KEYTOOL%" -help >NUL 2>&1 || set MY_KEYTOOL=%JV_HOME%\bin\keytool

openssl /? >NUL 2>&1 || GOTO noOSSL
set JB_HOME=%8
IF (%8)==() set JB_HOME="C:\Program Files\jboss-eap-5.0\jboss-as"
IF NOT EXIST %JB_HOME% GOTO noJB

REM remove " from %7
set EAR_LIB=%7
set EAR_LIB=%EAR_LIB:"=%
REM Now add the lib sub-dir
set EAR_LIB=%EAR_LIB%\lib
set CP=%EAR_LIB%\rhevmencryptutils-3.0.0-0001.jar;%EAR_LIB%\rhevm-compat.jar;%JB_HOME%\common\lib\commons-logging.jar;%EAR_LIB%\commons-codec-1.4.jar

if "%1"=="-pfx" (
  GOTO doPFX
) else if "%1"=="-jks" (
  GOTO doJKS
) else (
  GOTO doEncDec
)

:doPFX
set PKEY_8=privatekey.pkcs8
set PKEY_64=privatekey.b64
set CERT_64=certificate.b64
set CERT_P12=rhevm.pfx
%MY_KEYTOOL% -export -rfc -keystore %3 -storepass %4 -alias %5 > %CERT_64%
"%MY_JAVA%" -cp %CP% org.ovirt.engine.core.rhevmencryptutils.StoreUtils -pvk -store=%3 -pass=%4 -alias=%5 > %PKEY_8%
echo -----BEGIN PRIVATE KEY----- > %PKEY_64%
openssl enc -in %PKEY_8% -a >> %PKEY_64%
echo -----END PRIVATE KEY----- >> %PKEY_64%
openssl pkcs12 -inkey %PKEY_64% -in %CERT_64% -out %CERT_P12% -export -password pass:%4
set RES=%ERRORLEVEL%

IF NOT "%RES%"=="0" (
	echo "ERROR occured, status: %RES%"
	del /q %CERT_P12%
	EXIT %INTERNAL% %RES%
)
del /q %PKEY_8% %PKEY_64% %CERT_64%
rem echo Created new PFX file: %CERT_P12%
endlocal
EXIT %INTERNAL% %RES%

:doJKS
set curFile=%6
IF NOT EXIST %curFile% GOTO noFile

set curFile=%7
IF NOT EXIST %curFile% GOTO noFile

REM Import PFX
%MY_KEYTOOL% -importkeystore -srckeystore %6 -srcstoretype PKCS12 -srcstorepass %4 -deststoretype JKS -destkeystore %3 -deststorepass %4
set RES=%ERRORLEVEL%

IF NOT "%RES%"=="0" (
	echo "Error trying to import the PFX file %6, exiting."
	del /q %3
	EXIT %INTERNAL% %RES%
)

REM Add missing alias
%MY_KEYTOOL% -changealias -storepass %4 -keystore %3 -alias 1 -destalias %5
set RES=%ERRORLEVEL%

IF NOT "%RES%"=="0" (
	echo "Error fixing alias. Exiting."
	del /q %3
	EXIT %INTERNAL% %RES%
)

REM Convert PEM to DER
openssl x509 -in %7 -out tmp.der -outform DER
set RES=%ERRORLEVEL%

IF NOT "%RES%"=="0" (
	echo "Error converting CA certificate. Exiting."
	del /q %3
	EXIT %INTERNAL% %RES%
)

REM Add the CA certificate
%MY_KEYTOOL% -import -noprompt -keystore %3 -storepass %4 -alias cacert -file tmp.der
set RES=%ERRORLEVEL%

IF NOT "%RES%"=="0" (
	echo "Error importing CA certificate. Exiting."
	del /q %3 tmp.der
	EXIT %INTERNAL% %RES%
)

del /q tmp.der
endlocal
EXIT %INTERNAL% %ERRORLEVEL%

:doEncDec
"%MY_JAVA%" -cp %CP% org.ovirt.engine.core.rhevmencryptutils.StoreUtils %1 -store=%3 -pass=%4 -string=%6 -alias=%5
endlocal
EXIT %INTERNAL% %ERRORLEVEL%

:Usage
ECHO	store-utils.bat - A collection of encryption/decryption utilities using keystore.
ECHO	USAGE:
ECHO	Main mode
ECHO		store-utils {-enc/-dec/-pfx} {internal} {store} {pass] {alias} {string} {ear} [jboss home]
ECHO	Upgrade mode
ECHO		store-utils -jks {internal} {store} {pass} {alias} {PFX file} {CA PEM file}
ECHO	Where:
ECHO		Internal     = "0" - perform Exit , "1" - perform Exit /B
ECHO		Store        = path to keystore file.
ECHO		Pass         = keystore password.
ECHO		Alias        = Certificate alias in keystore.
ECHO		String       = string to encrypt or decrypt. You may use double quotes (" ") to encrypt a phrase.
ECHO		EAR          = Path to engine ear dir.
ECHO		JBoss home   = Path to jboss-as dir.
ECHO		PFX file     = Path to exiting PFX file, with private key and a certificate.
ECHO		CA PEM file  = Path to a CA certificate file in PEM format.
endlocal
Exit %INTERNAL% 1

:noJava
ECHO Can't find Java. Please verify it's in the path.
endlocal
Exit %INTERNAL% 1

:noJB
ECHO Can't find jboss-as folder. Please specify it as JBoss home.
endlocal
Exit %INTERNAL% 1

:noOSSL
ECHO Can't find OpenSSL. Please verify it's in the path.
endlocal
Exit %INTERNAL% 1

:noFile
ECHO File %curFile% does not exist!
endlocal
Exit %INTERNAL% 1
