PRINT 'Processing ad_groups_sp.sql'

----------------------------------------------------------------
-- [dbo].[ad_groups] Table
--
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Insertad_groups')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Insertad_groups] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Insertad_groups]
    @id uniqueidentifier,
	@name nvarchar(255),
	@status int,
	@domain nvarchar(100),
	@distinguishedname nvarchar(MAX)
AS
BEGIN
	SET NOCOUNT ON
	
	BEGIN TRY
    INSERT INTO [dbo].[ad_groups] ([id], [name],[status],[domain],[distinguishedname])
	VALUES (@id, @name,@status,@domain,@distinguishedname)
    
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH
    
    SET NOCOUNT OFF
END    

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Updatead_groups')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Updatead_groups] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Updatead_groups]
    @id uniqueidentifier,
	@name nvarchar(255),
	@status int,
	@domain nvarchar(100),
	@distinguishedname nvarchar(MAX)
AS
BEGIN

	--The [dbo].[ad_groups] table doesn't have a timestamp column. Optimistic concurrency logic cannot be generated
	SET NOCOUNT ON

	BEGIN TRY
	UPDATE [dbo].[ad_groups] 
	SET [name] = @name,
		[status] = @status,
		[domain] = @domain,
		[distinguishedname]=@distinguishedname
	WHERE [id]=@id

	IF @@ROWCOUNT = 0
	BEGIN
		RAISERROR('Update statement affected 0 rows.', 16, 2)
	END
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH	

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Deletead_groups')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Deletead_groups] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Deletead_groups]
	 @id uniqueidentifier
AS
BEGIN
	SET NOCOUNT ON
	BEGIN TRY
		DELETE FROM [dbo].[tags_user_group_map]
		WHERE [group_id] = @id

		DELETE FROM [dbo].[ad_groups]
		WHERE [id]=@id
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH
    
    SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetAllFromad_groups')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetAllFromad_groups] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetAllFromad_groups]    
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		[ad_groups].[id] AS 'id',
		[ad_groups].[name] AS 'name',
		[ad_groups].[status] AS 'status',
		[ad_groups].[domain] AS 'domain',
		[ad_groups].[distinguishedname] AS 'distinguishedname'
		FROM [dbo].[ad_groups] [ad_groups]
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Getad_groupsByid')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Getad_groupsByid] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Getad_groupsByid] 
	@id uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		[ad_groups].[id] AS 'id',
		[ad_groups].[name] AS 'name',
		[ad_groups].[status] AS 'status',
		[ad_groups].[domain] AS 'domain',
		[ad_groups].[distinguishedname] AS 'distinguishedname'
		FROM [dbo].[ad_groups] [ad_groups]
		WHERE [id]=@id
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END
GO
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Getad_groupsByName')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Getad_groupsByName] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].Getad_groupsByName 
	@name nvarchar(256)
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		[ad_groups].[id] AS 'id',
		[ad_groups].[name] AS 'name',
		[ad_groups].[status] AS 'status',
		[ad_groups].[domain] AS 'domain',
		[ad_groups].[distinguishedname] AS 'distinguishedname'
		FROM [dbo].[ad_groups] [ad_groups]
		WHERE [name]=@name
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END
GO

