PRINT 'Processing business_entity_snapshot_sp.sql'


IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'insert_entity_snapshot')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[insert_entity_snapshot] AS RETURN')
END
GO

ALTER PROCEDURE insert_entity_snapshot(@command_id uniqueidentifier, @command_type nvarchar(256) , @entity_id nvarchar(256), @entity_type nvarchar(256), @entity_snapshot text, @snapshot_type INTEGER, @snapshot_class nvarchar(128), @insertion_order INTEGER)
AS
BEGIN
	BEGIN
		INSERT INTO business_entity_snapshot(id, command_id, command_type, entity_id,entity_type,entity_snapshot, snapshot_class, snapshot_type,insertion_order)
				VALUES(newid(), @command_id, @command_type, @entity_id,@entity_type,@entity_snapshot, @snapshot_class, @snapshot_type,@insertion_order);
	END;
END
GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'get_entity_snapshot_by_id')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[get_entity_snapshot_by_id] AS RETURN')
END
GO

ALTER PROCEDURE get_entity_snapshot_by_id(@id uniqueidentifier)
AS
BEGIN
      SELECT business_entity_snapshot.*
      FROM business_entity_snapshot
      WHERE id = @id;
END
GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'get_entity_snapshot_by_command_id')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[get_entity_snapshot_by_command_id] AS RETURN')
END
GO

ALTER PROCEDURE get_entity_snapshot_by_command_id(@command_id uniqueidentifier)
AS
BEGIN
      SELECT business_entity_snapshot.*
      FROM business_entity_snapshot
      WHERE command_id = @command_id order by insertion_order DESC;
END
GO


IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'get_all_commands')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[get_all_commands] AS RETURN')
END
GO

ALTER PROCEDURE get_all_commands
AS
BEGIN
      SELECT distinct  business_entity_snapshot.command_id,  business_entity_snapshot.command_type
      FROM business_entity_snapshot
END
GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'delete_entity_snapshot_by_command_id')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[delete_entity_snapshot_by_command_id] AS RETURN')
END
GO

ALTER PROCEDURE delete_entity_snapshot_by_command_id(@command_id uniqueidentifier)
AS
BEGIN
      delete FROM business_entity_snapshot
      WHERE command_id = @command_id;
END
GO
