PRINT 'Processing event_sp.sql'
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO


----------------------------------------------------------------
-- [dbo].[event_map] Table
--
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetAllFromevent_map')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetAllFromevent_map] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetAllFromevent_map]    
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	
	SELECT
	[event_map].[event_up_name] AS 'event_up_name',
	[event_map].[event_down_name] AS 'event_down_name'
FROM [dbo].[event_map] [event_map]

	SET NOCOUNT OFF
END

GO

----------------------------------------------------------------
-- [dbo].[event_notification_hist] Table
--
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'insertevent_notification_hist')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[insertevent_notification_hist] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[insertevent_notification_hist]
    @v_audit_log_id bigint,
	@v_event_name nvarchar(100),
	@v_method_type  nchar(10),
	@v_reason nchar(255) = NULL,
	@v_sent_at datetime,
	@v_status bit,
	@v_subscriber_id uniqueidentifier
AS
BEGIN
	SET NOCOUNT ON
	
	BEGIN TRY
    INSERT INTO [dbo].[event_notification_hist] ([audit_log_id], [event_name], [method_type], [reason], [sent_at], [status], [subscriber_id])
	VALUES (@v_audit_log_id, @v_event_name, @v_method_type, @v_reason, @v_sent_at, @v_status, @v_subscriber_id)
    
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH
    
    SET NOCOUNT OFF
END    

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetAllFromevent_notification_hist')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetAllFromevent_notification_hist] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetAllFromevent_notification_hist]    
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	
	SELECT
	[event_notification_hist].[audit_log_id] AS 'audit_log_id',
	[event_notification_hist].[event_name] AS 'event_name',
	[event_notification_hist].[method_type] AS 'method_type',
	[event_notification_hist].[reason] AS 'reason',
	[event_notification_hist].[sent_at] AS 'sent_at',
	[event_notification_hist].[status] AS 'status',
	[event_notification_hist].[subscriber_id] AS 'subscriber_id'
FROM [dbo].[event_notification_hist] [event_notification_hist]

	SET NOCOUNT OFF
END

GO

----------------------------------------------------------------
-- [dbo].[event_notification_methods] Table
--
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetAllFromevent_notification_methods')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetAllFromevent_notification_methods] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetAllFromevent_notification_methods]    
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	
	SELECT
	[event_notification_methods].[method_id] AS 'method_id',
	[event_notification_methods].[method_type] AS 'method_type'
FROM [dbo].[event_notification_methods] [event_notification_methods]

	SET NOCOUNT OFF
END

GO


IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetAllFromevent_subscriber_notification_methods')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetAllFromevent_subscriber_notification_methods] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetAllFromevent_subscriber_notification_methods]    
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON	
	select * from event_subscriber_notification_methods_view
	SET NOCOUNT OFF
END

GO



----------------------------------------------------------------
-- [dbo].[event_subscriber] Table
--
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Insertevent_subscriber')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Insertevent_subscriber] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Insertevent_subscriber]
    @event_up_name nvarchar(100),
	@method_id int,
    @method_address nvarchar(255),
	@subscriber_id uniqueidentifier,
	@tag_name nvarchar(50) = null
AS
BEGIN
	SET NOCOUNT ON
	
	BEGIN TRY
		if not exists (select * from  event_subscriber where 
					   subscriber_id = @subscriber_id and
					   event_up_name = @event_up_name and
					   method_id = @method_id and
					   tag_name = @tag_name)
		begin
			INSERT INTO [dbo].[event_subscriber] ([event_up_name], [method_id], [method_address], [subscriber_id], [tag_name])
			VALUES (@event_up_name, @method_id, @method_address, @subscriber_id,@tag_name)
		end    
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH
    
    SET NOCOUNT OFF
END    

GO


IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetAllFromevent_subscriber')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetAllFromevent_subscriber] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetAllFromevent_subscriber]    
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	
	SELECT
	[event_subscriber].[event_up_name] AS 'event_up_name',
	[event_subscriber].[method_id] AS 'method_id',
	[event_subscriber].[method_address] AS 'method_address',
	[event_subscriber].[subscriber_id] AS 'subscriber_id',
    [event_subscriber].[tag_name] as 'tag_name'
FROM [dbo].[event_subscriber] [event_subscriber]

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Getevent_subscriberBysubscriber_id')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Getevent_subscriberBysubscriber_id] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].Getevent_subscriberBysubscriber_id    
	@subscriber_id uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	
	SELECT
	[event_subscriber].[event_up_name] AS 'event_up_name',
	[event_subscriber].[method_id] AS 'method_id',
	[event_subscriber].[method_address] AS 'method_address',
	[event_subscriber].[subscriber_id] AS 'subscriber_id',
    [event_subscriber].[tag_name] as 'tag_name'
	FROM [dbo].[event_subscriber] [event_subscriber]
	WHERE [subscriber_id] = @subscriber_id

	SET NOCOUNT OFF
END

GO

-------------------------------------------------------------------------------------
--- GetAllFromevent_audit_log_subscriber used to get un notified events
-------------------------------------------------------------------------------------
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetAllFromevent_audit_log_subscriber')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetAllFromevent_audit_log_subscriber] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetAllFromevent_audit_log_subscriber]    
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON

			declare @last bigint
			-- get last event
			select top 1 @last = audit_log_id from audit_log order by audit_log_id desc
			-- get from view all events with id <= @last
			select * from event_audit_log_subscriber_view  where audit_log_id <= @last

	SET NOCOUNT OFF
END
GO

----------------------------------------------------------------
-- Deleteevent_notification_hist deletes obselete entries
----------------------------------------------------------------
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Deleteevent_notification_hist')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Deleteevent_notification_hist] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Deleteevent_notification_hist]
	@v_sent_at datetime
AS
BEGIN
	SET NOCOUNT ON
	
	BEGIN TRY
    DELETE FROM [dbo].[event_notification_hist] WHERE sent_at < @v_sent_at

    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH

    SET NOCOUNT OFF
END
GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Deleteevent_subscriber')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Deleteevent_subscriber] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Deleteevent_subscriber]
    @event_up_name nvarchar(100) ,
	@method_id int ,	
	@subscriber_id uniqueidentifier,
    @tag_name nvarchar(50)= NULL
AS
BEGIN
	SET NOCOUNT ON
	BEGIN TRY
        if (@tag_name IS NULL)
		begin
			delete from event_subscriber 
			where [event_up_name] = @event_up_name
			and [method_id] = @method_id
			and [subscriber_id] = @subscriber_id 
		end
		else
		begin
			delete from event_subscriber 
			where [event_up_name] = @event_up_name
			and [method_id] = @method_id
			and [subscriber_id] = @subscriber_id 
			and [tag_name] = @tag_name	
		end
       
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH
    
    SET NOCOUNT OFF
END    
GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Updateevent_subscriber')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Updateevent_subscriber] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Updateevent_subscriber]
    @event_up_name nvarchar(100) ,
	@old_method_id int ,
	@new_method_id int ,
	@subscriber_id uniqueidentifier
AS
BEGIN
	SET NOCOUNT ON
	BEGIN TRY

	update event_subscriber set [method_id] = @new_method_id 
	where [event_up_name] = @event_up_name
    and [method_id] = @old_method_id
    and [subscriber_id] = @subscriber_id	    
   
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH
    
    SET NOCOUNT OFF
END    
GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetEventNotificationMethodById')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetEventNotificationMethodById] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetEventNotificationMethodById]
    @method_id int 
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		select method_id, method_type from dbo.event_notification_methods
		where method_id = @method_id
		   
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH
    
    SET NOCOUNT OFF
END    
GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetEventMapByName')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetEventMapByName] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetEventMapByName]
    @event_name nvarchar(100) 
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		select event_up_name, event_down_name from dbo.event_map
		where event_up_name = @event_name
		   
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH
    
    SET NOCOUNT OFF
END    
GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetEventNotificationMethodByType')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetEventNotificationMethodByType] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetEventNotificationMethodByType]
    @method_type nchar(10) 
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		select method_id, method_type from dbo.event_notification_methods
		where method_type = @method_type
		   
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH
    
    SET NOCOUNT OFF
END    
GO

