PRINT 'Processing image_group_storage_domain_map_sp.sql'

----------------------------------------------------------------
-- [dbo].[image_group_storage_domain_map] Table
--
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Insertimage_group_storage_domain_map')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Insertimage_group_storage_domain_map] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Insertimage_group_storage_domain_map]
	@image_group_id uniqueidentifier,
    @storage_domain_id uniqueidentifier
AS
BEGIN
	SET NOCOUNT ON
	
	BEGIN TRY
    INSERT INTO [dbo].[image_group_storage_domain_map] ([image_group_id], [storage_domain_id])
	VALUES (@image_group_id, @storage_domain_id)
    
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH
    
    SET NOCOUNT OFF
END    

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Deleteimage_group_storage_domain_map')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Deleteimage_group_storage_domain_map] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Deleteimage_group_storage_domain_map]
	@image_group_id uniqueidentifier,
	@storage_domain_id uniqueidentifier
AS
BEGIN
	SET NOCOUNT ON
	
    DELETE FROM [dbo].[image_group_storage_domain_map]
	WHERE [image_group_id]=@image_group_id AND [storage_domain_id]=@storage_domain_id
    
    SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetAllFromimage_group_storage_domain_map')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetAllFromimage_group_storage_domain_map] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetAllFromimage_group_storage_domain_map]    
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	
	SELECT
	[image_group_storage_domain_map].[image_group_id] AS 'image_group_id',
	[image_group_storage_domain_map].[storage_domain_id] AS 'storage_domain_id'
	FROM [dbo].[image_group_storage_domain_map]

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Getimage_grp_storage_domain_mapByimg_grp_idAndstorage_domain')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Getimage_grp_storage_domain_mapByimg_grp_idAndstorage_domain] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Getimage_grp_storage_domain_mapByimg_grp_idAndstorage_domain] 
	@image_group_id uniqueidentifier,
	@storage_domain_id uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	
	SELECT
	[image_group_storage_domain_map].[image_group_id] AS 'image_group_id',
	[image_group_storage_domain_map].[storage_domain_id] AS 'storage_domain_id'
	FROM [dbo].[image_group_storage_domain_map] 
	WHERE [image_group_id]=@image_group_id AND [storage_domain_id]=@storage_domain_id

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Getimage_group_storage_domain_mapByimage_group_id')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Getimage_group_storage_domain_mapByimage_group_id] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Getimage_group_storage_domain_mapByimage_group_id] 
	@image_group_id uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	
	SELECT
	[image_group_storage_domain_map].[image_group_id] AS 'image_group_id',
	[image_group_storage_domain_map].[storage_domain_id] AS 'storage_domain_id'
	FROM [dbo].[image_group_storage_domain_map]
	WHERE [image_group_id]=@image_group_id

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Getimage_group_storage_domain_mapBystorage_domain_id')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Getimage_group_storage_domain_mapBystorage_domain_id] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Getimage_group_storage_domain_mapBystorage_domain_id] 
	@storage_domain_id uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	
	SELECT
	[image_group_storage_domain_map].[image_group_id] AS 'image_group_id',
	[image_group_storage_domain_map].[storage_domain_id] AS 'storage_domain_id'
	FROM [dbo].[image_group_storage_domain_map]
	WHERE [storage_domain_id]=@storage_domain_id

	SET NOCOUNT OFF
END

GO
