PRINT 'Processing image_sp.sql'

----------------------------------------------------------------
-- [dbo].[images] Table
--
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'InsertImage')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[InsertImage] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[InsertImage]
	@creation_date datetime,
	@description nvarchar(max) = NULL,
	@image_guid uniqueidentifier,
	@internal_drive_mapping varchar(50) = NULL,
	@it_guid uniqueidentifier,
	@size bigint,
	@ParentId uniqueidentifier,
    @imageStatus int ,
    @lastModified datetime,
	@app_list nvarchar(MAX) = NULL,
	@storage_id uniqueidentifier = NULL,
	@vm_snapshot_id uniqueidentifier = NULL,
	@volume_type int,
	@volume_format int,
	@disk_type int,
	@image_group_id uniqueidentifier = NULL,
	@disk_interface int,
    @boot bit,
    @wipe_after_delete bit,
    @propagate_errors int
AS
BEGIN
	SET NOCOUNT ON
	
	BEGIN TRY
    INSERT INTO [dbo].[images] ( [creation_date], [description], [image_guid], [internal_drive_mapping], [it_guid], [size], [ParentId],[imageStatus],[lastModified], [app_list],
    [storage_id], [vm_snapshot_id], [volume_type], [image_group_id], [volume_format], [disk_type], [disk_interface], [boot], [wipe_after_delete], [propagate_errors])
	VALUES (@creation_date, @description, @image_guid, @internal_drive_mapping, @it_guid, @size, @ParentId, @imageStatus, @lastModified,@app_list,
	@storage_id, @vm_snapshot_id, @volume_type, @image_group_id, @volume_format, @disk_type, @disk_interface, @boot, @wipe_after_delete, @propagate_errors)
    
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH
    
    SET NOCOUNT OFF
END    

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'UpdateImage')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[UpdateImage] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[UpdateImage]
	@creation_date datetime,
	@description nvarchar(max) = NULL,
	@image_guid uniqueidentifier,
	@internal_drive_mapping varchar(50) = NULL,
	@it_guid uniqueidentifier,
	@size bigint,
	@ParentId uniqueidentifier,
    @imageStatus int ,
    @lastModified datetime,
	@app_list nvarchar(MAX) = NULL,
	@storage_id uniqueidentifier = NULL,
	@vm_snapshot_id uniqueidentifier = NULL,
	@volume_type int,
	@volume_format int,
	@disk_type int,
	@image_group_id uniqueidentifier = NULL,
	@disk_interface int,
    @boot int,
    @wipe_after_delete bit,
    @propagate_errors int
AS
BEGIN

	--The [dbo].[images] table doesn't have a timestamp column. Optimistic concurrency logic cannot be generated
	SET NOCOUNT ON

	BEGIN TRY
	UPDATE [dbo].[images] 
	SET [creation_date] = @creation_date, [description] = @description, [internal_drive_mapping] = @internal_drive_mapping, [it_guid] = @it_guid, [size] = @size, [ParentId] = @ParentId, [imageStatus] = @imageStatus, [lastModified] = @lastModified, [app_list] = @app_list,
	[storage_id] = @storage_id, [vm_snapshot_id] = @vm_snapshot_id, [volume_type] = @volume_type, [image_group_id] = @image_group_id, [volume_format] = @volume_format, [disk_type] = @disk_type, [disk_interface] = @disk_interface, [boot] = @boot, [wipe_after_delete] = @wipe_after_delete, [propagate_errors] = @propagate_errors, _update_date = getdate()
	WHERE [image_guid]=@image_guid

	IF @@ROWCOUNT = 0
	BEGIN
		RAISERROR('Update statement affected 0 rows.', 16, 2)
	END
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH	

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'DeleteImage')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[DeleteImage] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[DeleteImage]
	 @image_guid uniqueidentifier
AS
BEGIN
	SET NOCOUNT ON
	BEGIN TRY
		declare @val uniqueidentifier
		-- Get (and keep) a shared lock with "right to upgrade to exclusive"
		-- in order to force locking parent before children 
		SELECT @val = [image_guid]
		FROM [dbo].[images] WITH (UPDLOCK)
		WHERE [image_guid]=@image_guid

		DELETE FROM [dbo].[images]
		WHERE [image_guid]=@image_guid
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH
    
    SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetAllFromImages')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetAllFromImages] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetAllFromImages]    
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		null AS 'active',
		null AS 'vm_guid',
		[images_storage_domain_view].[creation_date] AS 'creation_date',
		[images_storage_domain_view].[actual_size] AS 'actual_size',
		[images_storage_domain_view].[description] AS 'description',
		[images_storage_domain_view].[image_guid] AS 'image_guid',
		[images_storage_domain_view].[internal_drive_mapping] AS 'internal_drive_mapping',
		[images_storage_domain_view].[it_guid] AS 'it_guid',
		[images_storage_domain_view].[size] AS 'size',
		[images_storage_domain_view].[ParentId] as 'ParentId',
		[images_storage_domain_view].[imageStatus] AS 'imageStatus',
		[images_storage_domain_view].[lastModified] AS 'lastModified',
		[images_storage_domain_view].[app_list] AS 'app_list',
		[images_storage_domain_view].[storage_id] AS 'storage_id',
		[images_storage_domain_view].[vm_snapshot_id] AS 'vm_snapshot_id',
		[images_storage_domain_view].[volume_type] AS 'volume_type',
		[images_storage_domain_view].[volume_format] AS 'volume_format',
		[images_storage_domain_view].[disk_type] AS 'disk_type',
		[images_storage_domain_view].[image_group_id] AS 'image_group_id',
		[images_storage_domain_view].[storage_path] AS 'storage_path',
		[images_storage_domain_view].[storage_pool_id] AS 'storage_pool_id',
		[images_storage_domain_view].[disk_interface] AS 'disk_interface',
		[images_storage_domain_view].[boot] AS 'boot',
		[images_storage_domain_view].[wipe_after_delete] AS 'wipe_after_delete',
		[images_storage_domain_view].[propagate_errors] AS 'propagate_errors',
		[images_storage_domain_view].[read_rate] AS 'read_rate',
		[images_storage_domain_view].[write_rate] AS 'write_rate'
	FROM [dbo].[images_storage_domain_view] [images_storage_domain_view]
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetImageByImageGuid')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetImageByImageGuid] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetImageByImageGuid] 
	@image_guid uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		[vm_images_view].[active] AS 'active',
		[vm_images_view].[vm_guid] AS 'vm_guid',
		[vm_images_view].[creation_date] AS 'creation_date',
		[vm_images_view].[actual_size] AS 'actual_size',
		[vm_images_view].[description] AS 'description',
		[vm_images_view].[image_guid] AS 'image_guid',
		[vm_images_view].[internal_drive_mapping] AS 'internal_drive_mapping',
		[vm_images_view].[it_guid] AS 'it_guid',
		[vm_images_view].[size] AS 'size',
		[vm_images_view].[ParentId] as 'ParentId',
		[vm_images_view].[imageStatus] AS 'imageStatus',
		[vm_images_view].[lastModified] AS 'lastModified',
		[vm_images_view].[app_list] AS 'app_list',
		[vm_images_view].[storage_id] AS 'storage_id',
		[vm_images_view].[vm_snapshot_id] AS 'vm_snapshot_id',
		[vm_images_view].[volume_type] AS 'volume_type',
		[vm_images_view].[volume_format] AS 'volume_format',
		[vm_images_view].[disk_type] AS 'disk_type',
		[vm_images_view].[image_group_id] AS 'image_group_id',
		[vm_images_view].[storage_path] AS 'storage_path',
		[vm_images_view].[storage_pool_id] AS 'storage_pool_id',
		[vm_images_view].[disk_interface] AS 'disk_interface',
		[vm_images_view].[boot] AS 'boot',
		[vm_images_view].[wipe_after_delete] AS 'wipe_after_delete',
		[vm_images_view].[propagate_errors] AS 'propagate_errors',
		[vm_images_view].[read_rate] AS 'read_rate',
		[vm_images_view].[write_rate] AS 'write_rate'
		FROM [dbo].[vm_images_view] [vm_images_view]
		WHERE [image_guid]=@image_guid
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetSnapshotByGuid')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetSnapshotByGuid] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetSnapshotByGuid] 
	@image_guid uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		null AS 'active',
		null AS 'vm_guid',
		[images_storage_domain_view].[creation_date] AS 'creation_date',
		[images_storage_domain_view].[actual_size] AS 'actual_size',
		[images_storage_domain_view].[description] AS 'description',
		[images_storage_domain_view].[image_guid] AS 'image_guid',
		[images_storage_domain_view].[internal_drive_mapping] AS 'internal_drive_mapping',
		[images_storage_domain_view].[it_guid] AS 'it_guid',
		[images_storage_domain_view].[size] AS 'size',
		[images_storage_domain_view].[ParentId] as 'ParentId',
		[images_storage_domain_view].[imageStatus] AS 'imageStatus',
		[images_storage_domain_view].[lastModified] AS 'lastModified',
		[images_storage_domain_view].[app_list] AS 'app_list',
		[images_storage_domain_view].[storage_id] AS 'storage_id',
		[images_storage_domain_view].[vm_snapshot_id] AS 'vm_snapshot_id',
		[images_storage_domain_view].[volume_type] AS 'volume_type',
		[images_storage_domain_view].[volume_format] AS 'volume_format',
		[images_storage_domain_view].[disk_type] AS 'disk_type',
		[images_storage_domain_view].[image_group_id] AS 'image_group_id',
		[images_storage_domain_view].[storage_path] AS 'storage_path',
		[images_storage_domain_view].[storage_pool_id] AS 'storage_pool_id',
		[images_storage_domain_view].[disk_interface] AS 'disk_interface',
		[images_storage_domain_view].[boot] AS 'boot',
		[images_storage_domain_view].[wipe_after_delete] AS 'wipe_after_delete',
		[images_storage_domain_view].[propagate_errors] AS 'propagate_errors',
		[images_storage_domain_view].[read_rate] AS 'read_rate',
		[images_storage_domain_view].[write_rate] AS 'write_rate'
		FROM [dbo].[images_storage_domain_view] [images_storage_domain_view]
		WHERE [image_guid]=@image_guid
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetSnapshotsByStorageDomainId')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetSnapshotsByStorageDomainId] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetSnapshotsByStorageDomainId] 
	@storage_domain_id uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		null AS 'active',
		null AS 'vm_guid',
		[images_storage_domain_view].[creation_date] AS 'creation_date',
		[images_storage_domain_view].[actual_size] AS 'actual_size',
		[images_storage_domain_view].[description] AS 'description',
		[images_storage_domain_view].[image_guid] AS 'image_guid',
		[images_storage_domain_view].[internal_drive_mapping] AS 'internal_drive_mapping',
		[images_storage_domain_view].[it_guid] AS 'it_guid',
		[images_storage_domain_view].[size] AS 'size',
		[images_storage_domain_view].[ParentId] as 'ParentId',
		[images_storage_domain_view].[imageStatus] AS 'imageStatus',
		[images_storage_domain_view].[lastModified] AS 'lastModified',
		[images_storage_domain_view].[app_list] AS 'app_list',
		[images_storage_domain_view].[storage_id] AS 'storage_id',
		[images_storage_domain_view].[vm_snapshot_id] AS 'vm_snapshot_id',
		[images_storage_domain_view].[volume_type] AS 'volume_type',
		[images_storage_domain_view].[volume_format] AS 'volume_format',
		[images_storage_domain_view].[disk_type] AS 'disk_type',
		[images_storage_domain_view].[image_group_id] AS 'image_group_id',
		[images_storage_domain_view].[storage_path] AS 'storage_path',
		[images_storage_domain_view].[storage_pool_id] AS 'storage_pool_id',
		[images_storage_domain_view].[disk_interface] AS 'disk_interface',
		[images_storage_domain_view].[boot] AS 'boot',
		[images_storage_domain_view].[wipe_after_delete] AS 'wipe_after_delete',
		[images_storage_domain_view].[propagate_errors] AS 'propagate_errors',
		[images_storage_domain_view].[read_rate] AS 'read_rate',
		[images_storage_domain_view].[write_rate] AS 'write_rate'
		FROM [dbo].[images_storage_domain_view] [images_storage_domain_view]
		WHERE [storage_id]=@storage_domain_id
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetSnapshotByParentGuid')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetSnapshotByParentGuid] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetSnapshotByParentGuid] 
	@parent_guid uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		null AS 'active',
		null AS 'vm_guid',
		[images_storage_domain_view].[creation_date] AS 'creation_date',
		[images_storage_domain_view].[actual_size] AS 'actual_size',
		[images_storage_domain_view].[description] AS 'description',
		[images_storage_domain_view].[image_guid] AS 'image_guid',
		[images_storage_domain_view].[internal_drive_mapping] AS 'internal_drive_mapping',
		[images_storage_domain_view].[it_guid] AS 'it_guid',
		[images_storage_domain_view].[size] AS 'size',
		[images_storage_domain_view].[ParentId] as 'ParentId',
		[images_storage_domain_view].[imageStatus] AS 'imageStatus',
		[images_storage_domain_view].[lastModified] AS 'lastModified',
		[images_storage_domain_view].[app_list] AS 'app_list',
		[images_storage_domain_view].[storage_id] AS 'storage_id',
		[images_storage_domain_view].[vm_snapshot_id] AS 'vm_snapshot_id',
		[images_storage_domain_view].[volume_type] AS 'volume_type',
		[images_storage_domain_view].[volume_format] AS 'volume_format',
		[images_storage_domain_view].[disk_type] AS 'disk_type',
		[images_storage_domain_view].[image_group_id] AS 'image_group_id',
		[images_storage_domain_view].[storage_path] AS 'storage_path',
		[images_storage_domain_view].[storage_pool_id] AS 'storage_pool_id',
		[images_storage_domain_view].[disk_interface] AS 'disk_interface',
		[images_storage_domain_view].[boot] AS 'boot',
		[images_storage_domain_view].[wipe_after_delete] AS 'wipe_after_delete',
		[images_storage_domain_view].[propagate_errors] AS 'propagate_errors',
		[images_storage_domain_view].[read_rate] AS 'read_rate',
		[images_storage_domain_view].[write_rate] AS 'write_rate'
		FROM [dbo].[images_storage_domain_view] [images_storage_domain_view]
		WHERE [parentId]=@parent_guid
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetVmImageByImageGuid')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetVmImageByImageGuid] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetVmImageByImageGuid] 
	@image_guid uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		[vm_images_view].[active] AS 'active',
		[vm_images_view].[creation_date] AS 'creation_date',
		[vm_images_view].[actual_size] AS 'actual_size',
		[vm_images_view].[description] AS 'description',
		[vm_images_view].[image_guid] AS 'image_guid',
		[vm_images_view].[internal_drive_mapping] AS 'internal_drive_mapping',
		[vm_images_view].[it_guid] AS 'it_guid',
		[vm_images_view].[size] AS 'size',
		[vm_images_view].[vm_guid] AS 'vm_guid',
		[vm_images_view].[ParentId] as 'ParentId',
		[vm_images_view].[imageStatus] AS 'imageStatus',
		[vm_images_view].[lastModified] AS 'lastModified',
		[vm_images_view].[app_list] AS 'app_list',
		[vm_images_view].[storage_id] AS 'storage_id',
		[vm_images_view].[vm_snapshot_id] AS 'vm_snapshot_id',
		[vm_images_view].[image_group_id] AS 'image_group_id',
		[vm_images_view].[volume_type] AS 'volume_type',
		[vm_images_view].[volume_format] AS 'volume_format',
		[vm_images_view].[disk_type] AS 'disk_type',
		[vm_images_view].[storage_path] AS 'storage_path',
		[vm_images_view].[storage_pool_id] AS 'storage_pool_id',
		[vm_images_view].[disk_interface] AS 'disk_interface',
		[vm_images_view].[boot] AS 'boot',
		[vm_images_view].[wipe_after_delete] AS 'wipe_after_delete',
		[vm_images_view].[propagate_errors] AS 'propagate_errors',
		[vm_images_view].[read_rate] AS 'read_rate',
		[vm_images_view].[write_rate] AS 'write_rate'
		FROM [dbo].[vm_images_view] [vm_images_view]
		WHERE [image_guid]=@image_guid
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetImagesByVmGuid')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetImagesByVmGuid] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetImagesByVmGuid] 
	@vm_guid uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		[vm_images_view].[active] AS 'active',
		[vm_images_view].[creation_date] AS 'creation_date',
		[vm_images_view].[actual_size] AS 'actual_size',
		[vm_images_view].[description] AS 'description',
		[vm_images_view].[image_guid] AS 'image_guid',
		[vm_images_view].[internal_drive_mapping] AS 'internal_drive_mapping',
		[vm_images_view].[it_guid] AS 'it_guid',
		[vm_images_view].[size] AS 'size',
		[vm_images_view].[vm_guid] AS 'vm_guid',
		[vm_images_view].[ParentId] as 'ParentId',
		[vm_images_view].[imageStatus] AS 'imageStatus',
		[vm_images_view].[lastModified] AS 'lastModified',
		[vm_images_view].[app_list] AS 'app_list',
		[vm_images_view].[storage_id] AS 'storage_id',
		[vm_images_view].[vm_snapshot_id] AS 'vm_snapshot_id',
		[vm_images_view].[image_group_id] AS 'image_group_id',
		[vm_images_view].[volume_type] AS 'volume_type',
		[vm_images_view].[volume_format] AS 'volume_format',
		[vm_images_view].[disk_type] AS 'disk_type',
		[vm_images_view].[storage_path] AS 'storage_path',
		[vm_images_view].[storage_pool_id] AS 'storage_pool_id',
		[vm_images_view].[disk_interface] AS 'disk_interface',
		[vm_images_view].[boot] AS 'boot',
		[vm_images_view].[wipe_after_delete] AS 'wipe_after_delete',
		[vm_images_view].[propagate_errors] AS 'propagate_errors',
		[vm_images_view].[read_rate] AS 'read_rate',
		[vm_images_view].[write_rate] AS 'write_rate'
		FROM [dbo].[vm_images_view] [vm_images_view]
		WHERE 
			[vm_guid]=@vm_guid
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetSnapshotsByVmSnapshotId')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetSnapshotsByVmSnapshotId] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetSnapshotsByVmSnapshotId] 
	@vm_snapshot_id uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		null AS 'active',
		null AS 'vm_guid',
		[images_storage_domain_view].[creation_date] AS 'creation_date',
		[images_storage_domain_view].[actual_size] AS 'actual_size',
		[images_storage_domain_view].[description] AS 'description',
		[images_storage_domain_view].[image_guid] AS 'image_guid',
		[images_storage_domain_view].[internal_drive_mapping] AS 'internal_drive_mapping',
		[images_storage_domain_view].[it_guid] AS 'it_guid',
		[images_storage_domain_view].[size] AS 'size',
		[images_storage_domain_view].[ParentId] as 'ParentId',
		[images_storage_domain_view].[imageStatus] AS 'imageStatus',
		[images_storage_domain_view].[lastModified] AS 'lastModified',
		[images_storage_domain_view].[app_list] AS 'app_list',
		[images_storage_domain_view].[storage_id] AS 'storage_id',
		[images_storage_domain_view].[vm_snapshot_id] AS 'vm_snapshot_id',
		[images_storage_domain_view].[volume_type] AS 'volume_type',
		[images_storage_domain_view].[volume_format] AS 'volume_format',
		[images_storage_domain_view].[disk_type] AS 'disk_type',
		[images_storage_domain_view].[image_group_id] AS 'image_group_id',
		[images_storage_domain_view].[storage_path] AS 'storage_path',
		[images_storage_domain_view].[storage_pool_id] AS 'storage_pool_id',
		[images_storage_domain_view].[disk_interface] AS 'disk_interface',
		[images_storage_domain_view].[boot] AS 'boot',
		[images_storage_domain_view].[wipe_after_delete] AS 'wipe_after_delete',
		[images_storage_domain_view].[propagate_errors] AS 'propagate_errors',
		[images_storage_domain_view].[read_rate] AS 'read_rate',
		[images_storage_domain_view].[write_rate] AS 'write_rate'
		FROM [dbo].[images_storage_domain_view] [images_storage_domain_view]
		WHERE [vm_snapshot_id]=@vm_snapshot_id
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetSnapshotsByImageGroupId')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetSnapshotsByImageGroupId] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetSnapshotsByImageGroupId] 
	@image_group_id uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		null AS 'active',
		null AS 'vm_guid',
		[images_storage_domain_view].[creation_date] AS 'creation_date',
		[images_storage_domain_view].[actual_size] AS 'actual_size',
		[images_storage_domain_view].[description] AS 'description',
		[images_storage_domain_view].[image_guid] AS 'image_guid',
		[images_storage_domain_view].[internal_drive_mapping] AS 'internal_drive_mapping',
		[images_storage_domain_view].[it_guid] AS 'it_guid',
		[images_storage_domain_view].[size] AS 'size',
		[images_storage_domain_view].[ParentId] as 'ParentId',
		[images_storage_domain_view].[imageStatus] AS 'imageStatus',
		[images_storage_domain_view].[lastModified] AS 'lastModified',
		[images_storage_domain_view].[app_list] AS 'app_list',
		[images_storage_domain_view].[storage_id] AS 'storage_id',
		[images_storage_domain_view].[vm_snapshot_id] AS 'vm_snapshot_id',
		[images_storage_domain_view].[volume_type] AS 'volume_type',
		[images_storage_domain_view].[volume_format] AS 'volume_format',
		[images_storage_domain_view].[disk_type] AS 'disk_type',
		[images_storage_domain_view].[image_group_id] AS 'image_group_id',
		[images_storage_domain_view].[storage_path] AS 'storage_path',
		[images_storage_domain_view].[storage_pool_id] AS 'storage_pool_id',
		[images_storage_domain_view].[disk_interface] AS 'disk_interface',
		[images_storage_domain_view].[boot] AS 'boot',
		[images_storage_domain_view].[wipe_after_delete] AS 'wipe_after_delete',
		[images_storage_domain_view].[propagate_errors] AS 'propagate_errors',
		[images_storage_domain_view].[read_rate] AS 'read_rate',
		[images_storage_domain_view].[write_rate] AS 'write_rate'
		FROM [dbo].[images_storage_domain_view] [images_storage_domain_view]
		WHERE [image_group_id]=@image_group_id
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END
GO
