PRINT 'Processing tags_sp.sql'

----------------------------------------------------------------
-- [dbo].[tags] Table
--
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Inserttags')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Inserttags] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Inserttags]
    @description nvarchar(max) = NULL,
	@tag_id uniqueidentifier OUT,
	@tag_name nvarchar(50),
	@parent_id uniqueidentifier,
	@readonly bit = null, 
    @type int = 0
AS
BEGIN
	SET NOCOUNT ON
	
	BEGIN TRY
    SET @tag_id = newid()
	INSERT INTO [dbo].[tags] ([tag_id],[description], [tag_name],[parent_id],[readonly],[type])
	VALUES (@tag_id,@description, @tag_name,@parent_id,@readonly,@type)
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH
    
    SET NOCOUNT OFF
END    

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Updatetags')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Updatetags] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Updatetags]
    @description nvarchar(max) = NULL,
	@tag_id uniqueidentifier,
	@tag_name nvarchar(50),
	@parent_id uniqueidentifier,
	@readonly bit = null,
    @type int = 0
AS
BEGIN

	--The [dbo].[tags] table doesn't have a timestamp column. Optimistic concurrency logic cannot be generated
	SET NOCOUNT ON

	BEGIN TRY
	UPDATE [dbo].[tags] 
	SET [description] = @description, [tag_name] = @tag_name,
	[parent_id] = @parent_id,
	[readonly]	= @readonly,
    [type] = @type,
	[_update_date] = getdate()
	WHERE [tag_id]=@tag_id

	IF @@ROWCOUNT = 0
	BEGIN
		RAISERROR('Update statement affected 0 rows.', 16, 2)
	END
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH	

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Deletetags')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Deletetags] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Deletetags]
  @tag_id uniqueidentifier  
AS
BEGIN
	SET NOCOUNT ON
	BEGIN TRY
			declare @val uniqueidentifier
			-- Get (and keep) a shared lock with "right to upgrade to exclusive"
			-- in order to force locking parent before children 
			SELECT @val = [tag_id]
			FROM [dbo].[tags] WITH (UPDLOCK)
			WHERE [tag_id] = @tag_id

			DELETE FROM [dbo].[tags_user_group_map]
			WHERE [tag_id]=@tag_id

			DELETE FROM [dbo].[tags_user_map]
			WHERE [tag_id]=@tag_id

			DELETE FROM [dbo].[tags_vm_map]
			WHERE [tag_id]=@tag_id

			DELETE FROM [dbo].[tags_vds_map]
			WHERE [tag_id]=@tag_id
			DELETE FROM [dbo].[tags_vm_pool_map]
			WHERE [tag_id]=@tag_id

			DELETE FROM [dbo].[tags]
			WHERE [tag_id]=@tag_id
	END TRY
    BEGIN CATCH
		EXEC RethrowError;
	END CATCH

    SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetAllFromtags')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetAllFromtags] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetAllFromtags]    
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		[tags].[description] AS 'description',
		[tags].[tag_id] AS 'tag_id',
		[tags].[tag_name] AS 'tag_name',
		[tags].[parent_id] AS 'parent_id',
		[tags].[readonly] AS 'readonly',
		[tags].[type] AS 'type'
	FROM [dbo].[tags] [tags]
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GettagsBytag_id')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GettagsBytag_id] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GettagsBytag_id] 
 @tag_id uniqueidentifier  
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		[tags].[description] AS 'description',
		[tags].[tag_id] AS 'tag_id',
		[tags].[tag_name] AS 'tag_name',
		[tags].[parent_id] AS 'parent_id',
		[tags].[readonly] AS 'readonly',
		[tags].[type] AS 'type'
		FROM [dbo].[tags] [tags]
		WHERE [tag_id]=@tag_id
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GettagsByparent_id')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GettagsByparent_id] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GettagsByparent_id] 
 @parent_id uniqueidentifier  
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		[tags].[description] AS 'description',
		[tags].[tag_id] AS 'tag_id',
		[tags].[tag_name] AS 'tag_name',
		[tags].[parent_id] AS 'parent_id',
		[tags].[readonly] AS 'readonly',
		[tags].[type] AS 'type'
		FROM [dbo].[tags] [tags]
		WHERE [parent_id]=@parent_id
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GettagsBytag_name')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GettagsBytag_name] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GettagsBytag_name] 
	@tag_name nvarchar(50)
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		[tags].[description] AS 'description',
		[tags].[tag_id] AS 'tag_id',
		[tags].[tag_name] AS 'tag_name',
		[tags].[parent_id] AS 'parent_id',
		[tags].[readonly] AS 'readonly',
		[tags].[type] AS 'type'
		FROM [dbo].[tags] [tags]
		WHERE [tag_name]=@tag_name
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO

----------------------------------------------------------------
-- [dbo].[tags_user_group_map] Table
--
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Inserttags_user_group_map')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Inserttags_user_group_map] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Inserttags_user_group_map]
    @group_id uniqueidentifier,  
 @tag_id uniqueidentifier  
AS
BEGIN
	SET NOCOUNT ON
	
	BEGIN TRY
    INSERT INTO [dbo].[tags_user_group_map] ([group_id], [tag_id])
	VALUES (@group_id, @tag_id)
    
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH
    
    SET NOCOUNT OFF
END    

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Deletetags_user_group_map')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Deletetags_user_group_map] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Deletetags_user_group_map]
  @group_id uniqueidentifier,  
 @tag_id uniqueidentifier  
AS
BEGIN
	SET NOCOUNT ON
	BEGIN TRY
		DELETE FROM [dbo].[tags_user_group_map]
		WHERE [group_id]=@group_id AND [tag_id]=@tag_id
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH
    
    SET NOCOUNT OFF
END

GO


IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetAllFromtags_user_group_map')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetAllFromtags_user_group_map] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetAllFromtags_user_group_map]    
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		[tags_user_group_map].[group_id] AS 'group_id',
		[tags_user_group_map].[tag_id] AS 'tag_id'
	FROM [dbo].[tags_user_group_map] [tags_user_group_map]
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetTagUserGroupByGroupIdAndByTagId')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetTagUserGroupByGroupIdAndByTagId] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetTagUserGroupByGroupIdAndByTagId] 
 @group_id uniqueidentifier,  
 @tag_id uniqueidentifier  
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		[tags_user_group_map].[group_id] AS 'group_id',
		[tags_user_group_map].[tag_id] AS 'tag_id'
		FROM [dbo].[tags_user_group_map] [tags_user_group_map]
		WHERE [group_id]=@group_id AND [tag_id]=@tag_id
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Gettags_user_group_mapByTagName')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Gettags_user_group_mapByTagName] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Gettags_user_group_mapByTagName] 
	@tag_name NVARCHAR(50)
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		[group_id] AS 'group_id',
		[tag_id] AS 'tag_id'
		FROM [dbo].[tags_user_group_map_view] 
		WHERE [tag_name]=@tag_name 
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetTagsByUserGroupId')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetTagsByUserGroupId] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetTagsByUserGroupId] 
	@group_ids nvarchar(max)
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		distinct ([tags_user_group_map_view].[tag_id]) AS 'tag_id',
		[tags_user_group_map_view].[tag_name] AS 'tag_name',
		[tags_user_group_map_view].[parent_id] AS 'parent_id',
		[tags_user_group_map_view].[readonly] AS 'readonly',
		[tags_user_group_map_view].[type] AS 'type'
		FROM [dbo].[tags_user_group_map_view] [tags_user_group_map_view]
		WHERE [group_id] in (select id from fnSplitter(@group_ids))
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetUserGroupTagsByTagIds')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].GetUserGroupTagsByTagIds AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetUserGroupTagsByTagIds] 
	@tag_ids nvarchar(max)
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		distinct ([tags_user_group_map_view].[tag_id]) AS 'tag_id',
		[tags_user_group_map_view].[tag_name] AS 'tag_name',
		[tags_user_group_map_view].[parent_id] AS 'parent_id',
		[tags_user_group_map_view].[readonly] AS 'readonly',
		[tags_user_group_map_view].[type] AS 'type'
		FROM [dbo].[tags_user_group_map_view] [tags_user_group_map_view]
		WHERE [tag_id] in (select id from fnSplitter(@tag_ids))
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO
----------------------------------------------------------------
-- [dbo].[tags_user_map] Table
--
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Inserttags_user_map')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Inserttags_user_map] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Inserttags_user_map]
    @tag_id uniqueidentifier,  
 @user_id uniqueidentifier  
AS
BEGIN
	SET NOCOUNT ON
	
	BEGIN TRY
    INSERT INTO [dbo].[tags_user_map] ([tag_id], [user_id])
	VALUES (@tag_id, @user_id)
    
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH
    
    SET NOCOUNT OFF
END    

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Deletetags_user_map')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Deletetags_user_map] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Deletetags_user_map]
  @tag_id uniqueidentifier,  
 @user_id uniqueidentifier  
AS
BEGIN
	SET NOCOUNT ON
	BEGIN TRY
		DELETE FROM [dbo].[tags_user_map]
		WHERE [tag_id]=@tag_id AND [user_id]=@user_id
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH
    
    SET NOCOUNT OFF
END

GO


IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetAllFromtags_user_map')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetAllFromtags_user_map] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetAllFromtags_user_map]    
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		[tags_user_map].[tag_id] AS 'tag_id',
		[tags_user_map].[user_id] AS 'user_id'
	FROM [dbo].[tags_user_map] [tags_user_map]
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetTagUserByTagIdAndByuserId')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetTagUserByTagIdAndByuserId] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetTagUserByTagIdAndByuserId] 
 @tag_id uniqueidentifier,  
 @user_id uniqueidentifier  
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		[tags_user_map].[tag_id] AS 'tag_id',
		[tags_user_map].[user_id] AS 'user_id'
		FROM [dbo].[tags_user_map] [tags_user_map]
		WHERE [tag_id]=@tag_id AND [user_id]=@user_id
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Gettags_user_mapByTagName')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Gettags_user_mapByTagName] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Gettags_user_mapByTagName] 
	@tag_name nvarchar(50)
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		[tags_user_map_view].[tag_id] AS 'tag_id',
		[tags_user_map_view].[user_id] AS 'user_id'
		FROM [dbo].[tags_user_map_view] [tags_user_map_view]
		WHERE [tag_name]=@tag_name
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetTagsByUserId')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetTagsByUserId] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetTagsByUserId] 
	@user_ids nvarchar(max)
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		distinct ([tags_user_map_view].[tag_id]) AS 'tag_id',
		[tags_user_map_view].[tag_name] AS 'tag_name',
		[tags_user_map_view].[parent_id] AS 'parent_id',
		[tags_user_map_view].[readonly] AS 'readonly',
		[tags_user_map_view].[type] AS 'type'
		FROM [dbo].[tags_user_map_view] [tags_user_map_view]
		WHERE [user_id] in (select id from fnSplitter(@user_ids))
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetUserTagsByTagIds')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetUserTagsByTagIds] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetUserTagsByTagIds] 
	@tag_ids nvarchar(max)
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		distinct ([tags_user_map_view].[tag_id]) AS 'tag_id',
		[tags_user_map_view].[tag_name] AS 'tag_name',
		[tags_user_map_view].[parent_id] AS 'parent_id',
		[tags_user_map_view].[readonly] AS 'readonly',
		[tags_user_map_view].[type] AS 'type'
		FROM [dbo].[tags_user_map_view] [tags_user_map_view]
		WHERE [tag_id] in (select id from fnSplitter(@tag_ids))
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO
----------------------------------------------------------------
-- [dbo].[tags_vds_map] Table
--
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Inserttags_vds_map')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Inserttags_vds_map] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Inserttags_vds_map]
    @tag_id uniqueidentifier,  
 @vds_id uniqueidentifier  
AS
BEGIN
	SET NOCOUNT ON
	
	BEGIN TRY
    INSERT INTO [dbo].[tags_vds_map] ([tag_id], [vds_id])
	VALUES (@tag_id, @vds_id)
    
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH
    
    SET NOCOUNT OFF
END    

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Deletetags_vds_map')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Deletetags_vds_map] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Deletetags_vds_map]
  @tag_id uniqueidentifier,  
 @vds_id uniqueidentifier  
AS
BEGIN
	SET NOCOUNT ON
	BEGIN TRY
		DELETE FROM [dbo].[tags_vds_map]
		WHERE [tag_id]=@tag_id AND [vds_id]=@vds_id
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH
    
    SET NOCOUNT OFF
END

GO


IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetAllFromtags_vds_map')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetAllFromtags_vds_map] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetAllFromtags_vds_map]    
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		[tags_vds_map].[tag_id] AS 'tag_id',
		[tags_vds_map].[vds_id] AS 'vds_id'
	FROM [dbo].[tags_vds_map] [tags_vds_map]
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetTagVdsBytagIdAndByVdsId')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetTagVdsBytagIdAndByVdsId] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetTagVdsBytagIdAndByVdsId] 
 @tag_id uniqueidentifier,  
 @vds_id uniqueidentifier  
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		[tags_vds_map].[tag_id] AS 'tag_id',
		[tags_vds_map].[vds_id] AS 'vds_id'
		FROM [dbo].[tags_vds_map] [tags_vds_map]
		WHERE [tag_id]=@tag_id AND [vds_id]=@vds_id
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Gettags_vds_mapByTagName')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Gettags_vds_mapByTagName] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Gettags_vds_mapByTagName] 
	@tag_name nvarchar(50)
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		[tags_vds_map_view].[tag_id] AS 'tag_id',
		[tags_vds_map_view].[vds_id] AS 'vds_id'
		FROM [dbo].[tags_vds_map_view] [tags_vds_map_view]
		WHERE [tag_name]=@tag_name
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetTagsByVdsId')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetTagsByVdsId] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetTagsByVdsId] 
	@vds_ids nvarchar(max)
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		distinct([tags_vds_map_view].[tag_id]) AS 'tag_id',
		[tags_vds_map_view].[tag_name] AS 'tag_name',
		[tags_vds_map_view].[parent_id] AS 'parent_id',
		[tags_vds_map_view].[readonly] AS 'readonly',
		[tags_vds_map_view].[type] AS 'type'
		FROM [dbo].[tags_vds_map_view] [tags_vds_map_view]
		WHERE [vds_id] in (select id from fnSplitter(@vds_ids))
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetVdsTagsByTagIds')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetVdsTagsByTagIds] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetVdsTagsByTagIds] 
	@tag_ids nvarchar(max)
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		distinct([tags_vds_map_view].[tag_id]) AS 'tag_id',
		[tags_vds_map_view].[tag_name] AS 'tag_name',
		[tags_vds_map_view].[parent_id] AS 'parent_id',
		[tags_vds_map_view].[readonly] AS 'readonly',
		[tags_vds_map_view].[type] AS 'type'
		FROM [dbo].[tags_vds_map_view] [tags_vds_map_view]
		WHERE [tag_id] in (select id from fnSplitter(@tag_ids))
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO
----------------------------------------------------------------
-- [dbo].[tags_vm_map] Table
--
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Inserttags_vm_map')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Inserttags_vm_map] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Inserttags_vm_map]
    @tag_id uniqueidentifier,  
 @vm_id uniqueidentifier,  
    @DefaultDisplayType int = 0  
AS
BEGIN
	SET NOCOUNT ON
	
	BEGIN TRY
    INSERT INTO [dbo].[tags_vm_map] ([tag_id], [vm_id], [DefaultDisplayType])
	VALUES (@tag_id, @vm_id, @DefaultDisplayType)
    
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH
    
    SET NOCOUNT OFF
END    

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Deletetags_vm_map')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Deletetags_vm_map] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Deletetags_vm_map]
  @tag_id uniqueidentifier,  
 @vm_id uniqueidentifier  
AS
BEGIN
	SET NOCOUNT ON
	BEGIN TRY
		DELETE FROM [dbo].[tags_vm_map]
		WHERE [tag_id]=@tag_id AND [vm_id]=@vm_id
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH
    
    SET NOCOUNT OFF
END

GO


IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetAllFromtags_vm_map')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetAllFromtags_vm_map] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetAllFromtags_vm_map]    
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		[tags_vm_map].[tag_id] AS 'tag_id',
		[tags_vm_map].[vm_id] AS 'vm_id',
		[tags_vm_map].[DefaultDisplayType] AS 'DefaultDisplayType'
	FROM [dbo].[tags_vm_map] [tags_vm_map]
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetTagVmByTagIdAndByvmId')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetTagVmByTagIdAndByvmId] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetTagVmByTagIdAndByvmId] 
 @tag_id uniqueidentifier,  
 @vm_id uniqueidentifier  
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		[tags_vm_map].[tag_id] AS 'tag_id',
		[tags_vm_map].[vm_id] AS 'vm_id',
		[tags_vm_map].[DefaultDisplayType] AS 'DefaultDisplayType'
		FROM [dbo].[tags_vm_map] [tags_vm_map]
		WHERE [tag_id]=@tag_id AND [vm_id]=@vm_id
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Gettags_vm_mapByTagName')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Gettags_vm_mapByTagName] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Gettags_vm_mapByTagName] 
	@tag_name nvarchar(50)
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		[tags_vm_map_view].[tag_id] AS 'tag_id',
		[tags_vm_map_view].[vm_id] AS 'vm_id'
		FROM [dbo].[tags_vm_map_view] [tags_vm_map_view]
		WHERE [tag_name]=@tag_name
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetTagsByVmId')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetTagsByVmId] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetTagsByVmId] 
	@vm_ids nvarchar(max)
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		distinct ([tags_vm_map_view].[tag_id]) AS 'tag_id',
		[tags_vm_map_view].[tag_name] AS 'tag_name',
		[tags_vm_map_view].[parent_id] AS 'parent_id',
		[tags_vm_map_view].[readonly] AS 'readonly',
		[tags_vm_map_view].[type] AS 'type'
		FROM [dbo].[tags_vm_map_view] [tags_vm_map_view]
		WHERE [vm_id] in (select id from fnSplitter(@vm_ids))
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetVmTagsByTagId')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetVmTagsByTagId] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetVmTagsByTagId] 
	@tag_ids nvarchar(max)
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		distinct ([tags_vm_map_view].[tag_id]) AS 'tag_id',
		[tags_vm_map_view].[tag_name] AS 'tag_name',
		[tags_vm_map_view].[parent_id] AS 'parent_id',
		[tags_vm_map_view].[readonly] AS 'readonly',
		[tags_vm_map_view].[type] AS 'type'
		FROM [dbo].[tags_vm_map_view] [tags_vm_map_view]
		WHERE [tag_id] in (select id from fnSplitter(@tag_ids))
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'UpdateVmTagsDefaultDisplayType')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[UpdateVmTagsDefaultDisplayType] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[UpdateVmTagsDefaultDisplayType] 
    @tag_id uniqueidentifier,
	@vm_id uniqueidentifier, 
    @DefaultDisplayType int
AS
BEGIN

	SET NOCOUNT ON
	BEGIN TRY
        update tags_vm_map
        set DefaultDisplayType=@DefaultDisplayType
        where tags_vm_map.[tag_id] = @tag_id
        and tags_vm_map.vm_id = @vm_id
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetnVmTagsByVmId')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetnVmTagsByVmId] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetnVmTagsByVmId] 
	@vm_id uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
        select * from tags_vm_map
        where tags_vm_map.vm_id = @vm_id
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetnVmTagsByVmIdAndDefaultTag')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetnVmTagsByVmIdAndDefaultTag] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetnVmTagsByVmIdAndDefaultTag] 
	@vm_id uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
        select tags_vm_map.* from tags_vm_map
        inner join tags on tags.tag_id = tags_vm_map.tag_id
        where tags_vm_map.vm_id = @vm_id
        and tags.[type]=1
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'RemoveAllVmTagsByVmId')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[RemoveAllVmTagsByVmId] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[RemoveAllVmTagsByVmId] 
	@vm_id uniqueidentifier
AS
BEGIN

	SET NOCOUNT ON
	BEGIN TRY
        delete tags_vm_map
        where vm_id=@vm_id
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO

