PRINT 'Processing vds_groups_sp.sql'

----------------------------------------------------------------
-- [dbo].[vds_groups] Table
--
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'InsertVdsGroups')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[InsertVdsGroups] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[InsertVdsGroups]
    @description nvarchar(max) = NULL,
	@name nvarchar(40),
	@cpu_name nvarchar(255),
	@selection_algorithm int,
	@high_utilization int,
	@low_utilization int,
	@cpu_over_commit_duration_minutes int,
	@hypervisor_type int,
	@storage_pool_id uniqueidentifier = NULL,
	@max_vds_memory_over_commit int,
	@compatibility_version nvarchar(40),
	@transparent_hugepages bit = 0,
	@migrate_on_error int,
	@vds_group_id uniqueidentifier OUT
AS
BEGIN
	SET NOCOUNT ON
	
	BEGIN TRY
    SET @vds_group_id = newid()
	INSERT INTO [dbo].[vds_groups] ([vds_group_id],[description], [name], [cpu_name], [selection_algorithm], [high_utilization], [low_utilization],
	[cpu_over_commit_duration_minutes], [hypervisor_type], [storage_pool_id], [max_vds_memory_over_commit], [compatibility_version], [transparent_hugepages], [migrate_on_error])
	VALUES (@vds_group_id,@description, @name, @cpu_name, @selection_algorithm, @high_utilization, @low_utilization,
	@cpu_over_commit_duration_minutes, @hypervisor_type, @storage_pool_id,  @max_vds_memory_over_commit, @compatibility_version, @transparent_hugepages, @migrate_on_error)
    
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH
    
    SET NOCOUNT OFF
END    

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'UpdateVdsGroup')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[UpdateVdsGroup] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[UpdateVdsGroup]
    @description nvarchar(max) = NULL,
	@name nvarchar(40),
	@vds_group_id uniqueidentifier,
	@cpu_name nvarchar(255) = NULL,
	@selection_algorithm int,
	@high_utilization int,
	@low_utilization int,
	@cpu_over_commit_duration_minutes int,
	@hypervisor_type int,
	@storage_pool_id uniqueidentifier = NULL,
	@max_vds_memory_over_commit int,
	@compatibility_version nvarchar(40),
	@transparent_hugepages bit = 0,
	@migrate_on_error int
AS
BEGIN

	--The [dbo].[vds_groups] table doesn't have a timestamp column. Optimistic concurrency logic cannot be generated
	SET NOCOUNT ON

	BEGIN TRY
	UPDATE [dbo].[vds_groups] 
	SET [description] = @description, [name] = @name, [cpu_name]=@cpu_name, [selection_algorithm]=@selection_algorithm, [high_utilization]=@high_utilization, [low_utilization]=@low_utilization, 
	[cpu_over_commit_duration_minutes]=@cpu_over_commit_duration_minutes, [hypervisor_type]=@hypervisor_type, [storage_pool_id]=@storage_pool_id,  _update_date = getdate(),
	[max_vds_memory_over_commit] = @max_vds_memory_over_commit, [compatibility_version] = @compatibility_version, [transparent_hugepages] = @transparent_hugepages, [migrate_on_error] = @migrate_on_error
	WHERE [vds_group_id]=@vds_group_id

	IF @@ROWCOUNT = 0
	BEGIN
		RAISERROR('Update statement affected 0 rows.', 16, 2)
	END
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH	

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'DeleteVdsGroup')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[DeleteVdsGroup] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[DeleteVdsGroup]
  @vds_group_id uniqueidentifier  
AS
BEGIN
	SET NOCOUNT ON
	BEGIN TRY
		declare @val uniqueidentifier
		-- Get (and keep) a shared lock with "right to upgrade to exclusive"
		-- in order to force locking parent before children 
		SELECT @val = [vds_group_id]
		FROM [dbo].[vds_groups] WITH (UPDLOCK)
		WHERE [vds_group_id]=@vds_group_id

		DELETE FROM [dbo].[vds_groups]
		WHERE [vds_group_id]=@vds_group_id
		-- delete VDS group permissions --
		DELETE FROM [dbo].[permissions] where object_id = @vds_group_id 
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH
    
    SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetAllFromVdsGroups')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetAllFromVdsGroups] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetAllFromVdsGroups]    
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY	
		SELECT
		[vds_groups].[description] AS 'description',
		[vds_groups].[name] AS 'name',
		[vds_groups].[vds_group_id] AS 'vds_group_id',
		[vds_groups].[cpu_name] AS 'cpu_name',
		[vds_groups].[selection_algorithm] AS 'selection_algorithm',
		[vds_groups].[high_utilization] AS 'high_utilization',
		[vds_groups].[low_utilization] AS 'low_utilization',
		[vds_groups].[cpu_over_commit_duration_minutes] AS 'cpu_over_commit_duration_minutes',
		[vds_groups].[hypervisor_type] AS 'hypervisor_type',
		[vds_groups].[storage_pool_id] AS 'storage_pool_id',
		[vds_groups].[max_vds_memory_over_commit] AS 'max_vds_memory_over_commit',
		[vds_groups].[compatibility_version] AS 'compatibility_version',
		[vds_groups].[transparent_hugepages] AS 'transparent_hugepages',
		[vds_groups].[migrate_on_error] AS 'migrate_on_error'
		FROM [dbo].[vds_groups] [vds_groups]
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetVdsGroupByVdsGroupId')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetVdsGroupByVdsGroupId] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetVdsGroupByVdsGroupId] 
 @vds_group_id uniqueidentifier  
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		[vds_groups].[description] AS 'description',
		[vds_groups].[name] AS 'name',
		[vds_groups].[vds_group_id] AS 'vds_group_id',
		[vds_groups].[cpu_name] AS 'cpu_name',
		[vds_groups].[selection_algorithm] AS 'selection_algorithm',
		[vds_groups].[high_utilization] AS 'high_utilization',
		[vds_groups].[low_utilization] AS 'low_utilization',
		[vds_groups].[cpu_over_commit_duration_minutes] AS 'cpu_over_commit_duration_minutes',
		[vds_groups].[hypervisor_type] AS 'hypervisor_type',
		[vds_groups].[storage_pool_id] AS 'storage_pool_id',
		[vds_groups].[max_vds_memory_over_commit] AS 'max_vds_memory_over_commit',
		[vds_groups].[compatibility_version] AS 'compatibility_version',
		[vds_groups].[transparent_hugepages] AS 'transparent_hugepages',
		[vds_groups].[migrate_on_error] AS 'migrate_on_error'
		FROM [dbo].[vds_groups] [vds_groups]
		WHERE [vds_group_id]=@vds_group_id
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetVdsGroupByVdsGroupName')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetVdsGroupByVdsGroupName] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetVdsGroupByVdsGroupName] 
	@vds_group_name nvarchar (40)
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY	
		SELECT
		[vds_groups].[description] AS 'description',
		[vds_groups].[name] AS 'name',
		[vds_groups].[vds_group_id] AS 'vds_group_id',
		[vds_groups].[cpu_name] AS 'cpu_name',
		[vds_groups].[selection_algorithm] AS 'selection_algorithm',
		[vds_groups].[high_utilization] AS 'high_utilization',
		[vds_groups].[low_utilization] AS 'low_utilization',
		[vds_groups].[cpu_over_commit_duration_minutes] AS 'cpu_over_commit_duration_minutes',
		[vds_groups].[hypervisor_type] AS 'hypervisor_type',
		[vds_groups].[storage_pool_id] AS 'storage_pool_id',
		[vds_groups].[max_vds_memory_over_commit] AS 'max_vds_memory_over_commit',
		[vds_groups].[compatibility_version] AS 'compatibility_version',
		[vds_groups].[transparent_hugepages] AS 'transparent_hugepages',
		[vds_groups].[migrate_on_error] AS 'migrate_on_error'
		FROM [dbo].[vds_groups] [vds_groups]
		WHERE [name]=@vds_group_name
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetVdsGroupsByStoragePoolId')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetVdsGroupsByStoragePoolId] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetVdsGroupsByStoragePoolId] 
	@storage_pool_id uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY	
		SELECT
		[vds_groups].[description] AS 'description',
		[vds_groups].[name] AS 'name',
		[vds_groups].[vds_group_id] AS 'vds_group_id',
		[vds_groups].[cpu_name] AS 'cpu_name',
		[vds_groups].[selection_algorithm] AS 'selection_algorithm',
		[vds_groups].[high_utilization] AS 'high_utilization',
		[vds_groups].[low_utilization] AS 'low_utilization',
		[vds_groups].[cpu_over_commit_duration_minutes] AS 'cpu_over_commit_duration_minutes',
		[vds_groups].[hypervisor_type] AS 'hypervisor_type',
		[vds_groups].[storage_pool_id] AS 'storage_pool_id',
		[vds_groups].[max_vds_memory_over_commit] AS 'max_vds_memory_over_commit',
		[vds_groups].[compatibility_version] AS 'compatibility_version',
		[vds_groups].[transparent_hugepages] AS 'transparent_hugepages',
		[vds_groups].[migrate_on_error] AS 'migrate_on_error'
		FROM [dbo].[vds_groups] [vds_groups]
		WHERE [storage_pool_id]=@storage_pool_id
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO


IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetVdsGroupWithRunningVms')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetVdsGroupWithRunningVms] AS RETURN')
END

GO

--This SP returns the VDS group if it has running vms
ALTER PROCEDURE [dbo].[GetVdsGroupWithRunningVms] 
 @vds_group_id uniqueidentifier  
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		[vds_groups].[description] AS 'description',
		[vds_groups].[name] AS 'name',
		[vds_groups].[vds_group_id] AS 'vds_group_id',
		[vds_groups].[cpu_name] AS 'cpu_name',
		[vds_groups].[selection_algorithm] AS 'selection_algorithm',
		[vds_groups].[high_utilization] AS 'high_utilization',
		[vds_groups].[low_utilization] AS 'low_utilization',
		[vds_groups].[cpu_over_commit_duration_minutes] AS 'cpu_over_commit_duration_minutes',
		[vds_groups].[hypervisor_type] AS 'hypervisor_type',
		[vds_groups].[storage_pool_id] AS 'storage_pool_id',
		[vds_groups].[max_vds_memory_over_commit] AS 'max_vds_memory_over_commit',
		[vds_groups].[compatibility_version] AS 'compatibility_version',
		[vds_groups].[transparent_hugepages] AS 'transparent_hugepages',
		[vds_groups].[migrate_on_error] AS 'migrate_on_error'
		FROM [dbo].[vds_groups] [vds_groups]
		WHERE [vds_group_id]=@vds_group_id and [vds_group_id] in (select [vds_group_id] from [dbo].[vms] where [dbo].[vms].[status] NOT IN (0,13,14))
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO
