PRINT 'Processing vm_pool_map_sp.sql'

----------------------------------------------------------------
-- [dbo].[vm_pool_map] Table
--
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'InsertVm_pool_map')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[InsertVm_pool_map] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[InsertVm_pool_map]
    @vm_guid uniqueidentifier,  
 @vm_pool_id uniqueidentifier  
AS
BEGIN
	SET NOCOUNT ON
	
	BEGIN TRY
    INSERT INTO [dbo].[vm_pool_map] ([vm_guid], [vm_pool_id])
	VALUES (@vm_guid, @vm_pool_id)
    
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH
    
    SET NOCOUNT OFF
END    

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'UpdateVm_pool_map')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[UpdateVm_pool_map] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[UpdateVm_pool_map]
    @vm_guid uniqueidentifier,  
 @vm_pool_id uniqueidentifier  
AS
BEGIN

	--The [dbo].[vm_pool_map] table doesn't have a timestamp column. Optimistic concurrency logic cannot be generated
	SET NOCOUNT ON

	BEGIN TRY
	UPDATE [dbo].[vm_pool_map] 
	SET [vm_pool_id] = @vm_pool_id
	WHERE [vm_guid]=@vm_guid

	IF @@ROWCOUNT = 0
	BEGIN
		RAISERROR('Update statement affected 0 rows.', 16, 2)
	END
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH	

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'DeleteVm_pool_map')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[DeleteVm_pool_map] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[DeleteVm_pool_map]
	 @vm_guid uniqueidentifier
AS
BEGIN
	SET NOCOUNT ON
	BEGIN TRY
		declare @val nvarchar(50)
		-- Get (and keep) a shared lock with "right to upgrade to exclusive"
		-- in order to force locking parent before children 
		SELECT @val = [vm_guid]
		FROM [dbo].[vm_pool_map] WITH (UPDLOCK)
		WHERE [vm_guid]=@vm_guid

		DELETE FROM [dbo].[vm_pool_map]
		WHERE [vm_guid]=@vm_guid
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH
    
    SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetAllFromVm_pool_map')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetAllFromVm_pool_map] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetAllFromVm_pool_map]    
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		[vm_pool_map].[vm_guid] AS 'vm_guid',
		[vm_pool_map].[vm_pool_id] AS 'vm_pool_id'
		FROM [dbo].[vm_pool_map] [vm_pool_map]
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetVm_pool_mapByvm_guid')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetVm_pool_mapByvm_guid] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetVm_pool_mapByvm_guid] 
	@vm_guid uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		[vm_pool_map].[vm_guid] AS 'vm_guid',
		[vm_pool_map].[vm_pool_id] AS 'vm_pool_id'
		FROM [dbo].[vm_pool_map] [vm_pool_map]
		WHERE [vm_guid]=@vm_guid
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetVm_pool_mapByvm_pool_id')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetVm_pool_mapByvm_pool_id] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetVm_pool_mapByvm_pool_id] 
 @vm_pool_id uniqueidentifier  
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		[vm_pool_map].[vm_guid] AS 'vm_guid',
		[vm_pool_map].[vm_pool_id] AS 'vm_pool_id'
		FROM [dbo].[vm_pool_map] INNER JOIN [dbo].[vm_static]
					ON dbo.vm_pool_map.vm_guid = dbo.vm_static.vm_guid 
		WHERE [vm_pool_id]=@vm_pool_id
		ORDER BY dbo.vm_static.vm_name
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO

----------------------------------------------------------------
-- [dbo].[image_vm_pool_map] Table
--
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Insertimage_vm_pool_map')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Insertimage_vm_pool_map] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Insertimage_vm_pool_map]
    @image_guid uniqueidentifier,
	@internal_drive_mapping varchar(50) = NULL,
	@vm_guid uniqueidentifier
AS
BEGIN
	SET NOCOUNT ON
	
	BEGIN TRY
    INSERT INTO [dbo].[image_vm_pool_map] ([image_guid], [internal_drive_mapping], [vm_guid])
	VALUES (@image_guid, @internal_drive_mapping, @vm_guid)
    
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH
    
    SET NOCOUNT OFF
END    

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Updateimage_vm_pool_map')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Updateimage_vm_pool_map] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Updateimage_vm_pool_map]
    @image_guid uniqueidentifier,
	@internal_drive_mapping varchar(50) = NULL,
	@vm_guid uniqueidentifier
AS
BEGIN

	--The [dbo].[image_vm_pool_map] table doesn't have a timestamp column. Optimistic concurrency logic cannot be generated
	SET NOCOUNT ON

	BEGIN TRY
	UPDATE [dbo].[image_vm_pool_map] 
	SET [internal_drive_mapping] = @internal_drive_mapping, [vm_guid] = @vm_guid
	WHERE [image_guid]=@image_guid

	IF @@ROWCOUNT = 0
	BEGIN
		RAISERROR('Update statement affected 0 rows.', 16, 2)
	END
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH	

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Deleteimage_vm_pool_map')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Deleteimage_vm_pool_map] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Deleteimage_vm_pool_map]
	 @image_guid uniqueidentifier
AS
BEGIN
	SET NOCOUNT ON
	BEGIN TRY
		DELETE FROM [dbo].[image_vm_pool_map]
		WHERE [image_guid]=@image_guid
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH
    SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetAllFromimage_vm_pool_map')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetAllFromimage_vm_pool_map] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetAllFromimage_vm_pool_map]    
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		[image_vm_pool_map].[image_guid] AS 'image_guid',
		[image_vm_pool_map].[internal_drive_mapping] AS 'internal_drive_mapping',
		[image_vm_pool_map].[vm_guid] AS 'vm_guid'
		FROM [dbo].[image_vm_pool_map] [image_vm_pool_map]
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Getimage_vm_pool_mapByimage_guid')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Getimage_vm_pool_mapByimage_guid] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Getimage_vm_pool_mapByimage_guid] 
	@image_guid uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		[image_vm_pool_map].[image_guid] AS 'image_guid',
		[image_vm_pool_map].[internal_drive_mapping] AS 'internal_drive_mapping',
		[image_vm_pool_map].[vm_guid] AS 'vm_guid'
		FROM [dbo].[image_vm_pool_map] [image_vm_pool_map]
		WHERE [image_guid]=@image_guid
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Getimage_vm_pool_mapByvm_guid')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Getimage_vm_pool_mapByvm_guid] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Getimage_vm_pool_mapByvm_guid] 
	@vm_guid uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		[image_vm_pool_map].[image_guid] AS 'image_guid',
		[image_vm_pool_map].[internal_drive_mapping] AS 'internal_drive_mapping',
		[image_vm_pool_map].[vm_guid] AS 'vm_guid'
		FROM [dbo].[image_vm_pool_map] [image_vm_pool_map]
		WHERE [vm_guid]=@vm_guid
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO


