package org.ovirt.engine.api.restapi.resource;

import java.util.ArrayList;
import java.util.List;

import javax.ws.rs.core.Response;

import com.redhat.rhevm.api.model.Action;
import com.redhat.rhevm.api.model.DataCenter;
import com.redhat.rhevm.api.model.DataCenters;
import com.redhat.rhevm.api.model.StorageType;
import com.redhat.rhevm.api.model.SupportedVersions;
import com.redhat.rhevm.api.resource.DataCenterResource;
import com.redhat.rhevm.api.resource.DataCentersResource;

import org.ovirt.engine.core.common.action.StoragePoolManagementParameter;
import org.ovirt.engine.core.common.action.StoragePoolParametersBase;
import org.ovirt.engine.core.common.action.VdcActionType;
import org.ovirt.engine.core.common.businessentities.storage_pool;
import org.ovirt.engine.core.common.interfaces.SearchType;
import org.ovirt.engine.core.common.queries.GetAvailableStoragePoolVersionsParameters;
import org.ovirt.engine.core.common.queries.StoragePoolQueryParametersBase;
import org.ovirt.engine.core.common.queries.VdcQueryType;
import org.ovirt.engine.core.compat.Guid;

public class BackendDataCentersResource extends
        AbstractBackendCollectionResource<DataCenter, storage_pool> implements DataCentersResource {

    static final String[] SUB_COLLECTIONS = {"storagedomains", "permissions" };

    public BackendDataCentersResource() {
        super(DataCenter.class, storage_pool.class, SUB_COLLECTIONS);
    }

    @Override
    public DataCenters list() {
        return mapCollection(getBackendCollection(SearchType.StoragePool));
    }

    @Override
    @SingleEntityResource
    public DataCenterResource getDataCenterSubResource(String id) {
        return inject(new BackendDataCenterResource(id, this));
    }

    @Override
    public Response add(DataCenter dataCenter) {
        validateParameters(dataCenter, "name", "storageType");
        validateEnum(StorageType.class, dataCenter.getStorageType().toUpperCase());
        storage_pool entity = map(dataCenter);
        return performCreation(VdcActionType.AddEmptyStoragePool,
                               new StoragePoolManagementParameter(entity),
                               new QueryIdResolver(VdcQueryType.GetStoragePoolById, StoragePoolQueryParametersBase.class));
    }

    @Override
    public void performRemove(String id) {
        performAction(VdcActionType.RemoveStoragePool, new StoragePoolParametersBase(asGuid(id)));
    }

    @Override
    public void remove(String id, Action action) {
        getEntity(id);
        StoragePoolParametersBase params = new StoragePoolParametersBase(asGuid(id));
        if (action != null && action.isSetForce()) {
            params.setForceDelete(action.isForce());
        }
        performAction(VdcActionType.RemoveStoragePool, params);
    }

    private DataCenters mapCollection(List<storage_pool> entities) {
        DataCenters collection = new DataCenters();
        for (storage_pool entity : entities) {
            collection.getDataCenters().add(addLinks(populate(map(entity), entity)));
        }
        return collection;
    }

    @Override
    protected DataCenter populate(DataCenter model, storage_pool entity) {
        GetAvailableStoragePoolVersionsParameters parameters = new GetAvailableStoragePoolVersionsParameters();
        parameters.setStoragePoolId(new Guid(model.getId()));
        model.setSupportedVersions(getMapper(List.class,
                                             SupportedVersions.class).map(getEntity(ArrayList.class,
                                                                                    VdcQueryType.GetAvailableStoragePoolVersions,
                                                                                    parameters,
                                                                                    model.getId()),
                                                                          null));
        return model;
    }
}
