package org.ovirt.engine.api.restapi.resource;

import com.redhat.rhevm.api.model.Domain;
import com.redhat.rhevm.api.model.Group;
import com.redhat.rhevm.api.resource.DomainGroupResource;
import com.redhat.rhevm.api.resource.DomainGroupsResource;

public class BackendDomainGroupsResource extends AbstractBackendGroupsResource
implements DomainGroupsResource {

    private String directoryId;

    public BackendDomainGroupsResource(String id, BackendDomainResource parent) {
        super(id,parent);
        this.directoryId = id;
    }

    @Override
    public Group addParents(Group user) {
        user.setDomain(new Domain());
        user.getDomain().setId(directoryId);
        return user;
    }

    @Override
    @SingleEntityResource
    public DomainGroupResource getDomainGroupSubResource(String id) {
        return inject(new BackendDomainGroupResource(id, this));
    }
}
