package org.ovirt.engine.api.restapi.resource;

import com.redhat.rhevm.api.model.NIC;
import com.redhat.rhevm.api.model.Nics;
import com.redhat.rhevm.api.resource.ReadOnlyDevicesResource;
import org.ovirt.engine.core.common.businessentities.VmNetworkInterface;
import org.ovirt.engine.core.common.queries.VdcQueryParametersBase;
import org.ovirt.engine.core.common.queries.VdcQueryType;
import org.ovirt.engine.core.compat.Guid;

public class BackendReadOnlyNicsResource
        extends AbstractBackendReadOnlyDevicesResource<NIC, Nics, VmNetworkInterface>
        implements ReadOnlyDevicesResource<NIC, Nics> {

    public BackendReadOnlyNicsResource(Guid parentId, VdcQueryType queryType, VdcQueryParametersBase queryParams) {
        super(NIC.class, Nics.class, VmNetworkInterface.class, parentId, queryType, queryParams);
    }

    @Override
    protected boolean matchEntity(VmNetworkInterface entity, Guid id) {
        return id.equals(entity.getId());
    }
}
