package org.ovirt.engine.api.restapi.types;

import org.junit.Test;

import com.redhat.rhevm.api.model.LogicalUnit;
import com.redhat.rhevm.api.model.Storage;
import com.redhat.rhevm.api.model.StorageType;
import org.ovirt.engine.core.common.businessentities.LUNs;

public class StorageLogicalUnitMapperTest extends AbstractInvertibleMappingTest<Storage, LUNs, LUNs> {

    protected StorageLogicalUnitMapperTest() {
        super(Storage.class, LUNs.class, LUNs.class);
    }

    @Override
    protected Storage postPopulate(Storage from) {
        from.setType(MappingTestHelper.shuffle(StorageType.class).value());
        LogicalUnit unit = new LogicalUnit();
        unit.setId(from.getId());
        from.unsetLogicalUnits();
        from.getLogicalUnits().add(unit);
        return from;
    }

    @Override
    protected void verify(Storage model, Storage transform) {
        assertNotNull(transform);
        assertEquals(model.getId(), transform.getId());
        assertEquals(model.getType(), transform.getType());
        assertEquals(model.getLogicalUnits().size(), model.getLogicalUnits().size());
        for (int i = 0; i < model.getLogicalUnits().size(); i++) {
            assertEquals(model.getLogicalUnits().get(i).getId(), transform.getLogicalUnits().get(i).getId());
        }
    }

    @Test
    public void testOneWayMapping() {
        LUNs model = new LUNs();
        model.setVendorId("vendor_id_1");
        model.setProductId("product_id_1");
        model.setLunMapping(5);
        model.setSerial("some_serial");
        LogicalUnit entity = StorageLogicalUnitMapper.map(model, (LogicalUnit)null);
        assertEquals(entity.getVendorId(), "vendor_id_1");
        assertEquals(entity.getProductId(), "product_id_1");
        assertEquals(entity.getSerial(), "some_serial");
        assertEquals(entity.getLunMapping(), new Integer(5));
    }
}

