package org.ovirt.engine.core.config;

import org.junit.Test;
import org.ovirt.engine.core.config.validation.ConfigActionType;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;

public class RhevmConfigValidatorTest {

    /**
     * If an exception is thrown the test has failed, otherwise the test succeeded
     */
    @Test
    public void testSetValidatorWithValidArgs() {
        RhevmConfigMap rhevmConfigMap = mock(RhevmConfigMap.class);
        when(rhevmConfigMap.getKey()).thenReturn("keyToSet");
        when(rhevmConfigMap.getValue()).thenReturn("valueToSet");
        ConfigActionType setAction = ConfigActionType.ACTION_SET;
        setAction.validate(rhevmConfigMap);
    }

    /**
     * If an exception is thrown the test has failed, otherwise the test succeeded
     */
    @Test
    public void testGetValidatorWithValidArgs() {
        RhevmConfigMap rhevmConfigMap = mock(RhevmConfigMap.class);
        when(rhevmConfigMap.getKey()).thenReturn("keyToGet");
        ConfigActionType setAction = ConfigActionType.ACTION_GET;
        setAction.validate(rhevmConfigMap);
    }

    @Test(expected = IllegalArgumentException.class)
    public void testSetValidatorWithOutKey() {
        RhevmConfigMap rhevmConfigMap = mock(RhevmConfigMap.class);
        when(rhevmConfigMap.getKey()).thenReturn(null);
        when(rhevmConfigMap.getValue()).thenReturn("valueToSet");
        ConfigActionType setAction = ConfigActionType.ACTION_SET;
        setAction.validate(rhevmConfigMap);
    }

    @Test(expected = IllegalArgumentException.class)
    public void testSetValidatorWithOutValue() {
        RhevmConfigMap rhevmConfigMap = mock(RhevmConfigMap.class);
        when(rhevmConfigMap.getKey()).thenReturn("keyToSet");
        when(rhevmConfigMap.getValue()).thenReturn(null);
        ConfigActionType setAction = ConfigActionType.ACTION_SET;
        setAction.validate(rhevmConfigMap);
    }

    @Test(expected = IllegalArgumentException.class)
    public void testGetValidatorWithOutKey() {
        RhevmConfigMap rhevmConfigMap = mock(RhevmConfigMap.class);
        when(rhevmConfigMap.getKey()).thenReturn(null);
        ConfigActionType setAction = ConfigActionType.ACTION_GET;
        setAction.validate(rhevmConfigMap);
    }
}