#!/bin/sh

###########################################################################
# This script is used for extracting the fixed BZ numbers from the commit #
# messgaes in git log.                                                    #
# Usage for one component:                                                #
#   fixed_bzs.sh backend  c8b23865845239fa11091d7b09f08263437dee45        #
#                                                                         #
# Usage for number of components:                                         #
#   fixed_bzs.sh 'backend\|gwt' c8b23865845239fa11091d7b09f08263437dee45  #
#                                                                         #
# Usage for all components:                                               #
#   fixed_bzs.sh .* c8b23865845239fa11091d7b09f08263437dee45              #
###########################################################################


die () {
    printf >&2 "$@"
    exit 1
}

[ "$#" -ge 2 ] || die "Usage: fixed_bzs.sh <component> <since commit hash> [<until commit hash>]\n"

COMPONENT=$1
SINCE_COMMIT_HASH=$2
UNTIL_COMMIT_HASH=$3

git log $SINCE_COMMIT_HASH..$UNTIL_COMMIT_HASH --grep=$COMPONENT -i | grep bugzilla.redhat.com | sed -e 's/.*bugzilla.redhat.com\/[^0-9]*\([0-9]*\).*/\1/' | sort -u | tr '\n' ',' | sed -e 's/,$/\n/' -e 's/^,//'
