'''
Created on Jun 16, 2010

@author: mpastern@redhat.com
'''
import threading
import thread

class ThreadingBroker(threading.Thread):
    '''
    This class providing threading capabilities
    '''
     
    def __init__(self, group=None, target=None, name=None,
                 args=(), kwargs=None, verbose=None):
        threading.Thread.__init__(self,group=group, target=target, name=name,
                 args=args, kwargs=kwargs, verbose=verbose)
        self.__name = name
    
    '''
    Start a new thread and return its identifier.  
    The thread exits when the function returns; the return value is ignored.  
    The thread will also exit when the function raises an unhandled exception;
    '''    
    @staticmethod
    def run_method_as_thread(method,args=(),kwrags={}):
        return thread.start_new_thread(method, args,kwrags)
        
    '''
    Returns Lock object
    '''   
    @staticmethod
    def getThreadLock():
        return thread.allocate_lock()
    
    @staticmethod
    def enumerate():
        return threading.enumerate()
    
    @staticmethod
    def currentThread():
        return threading.currentThread()