'''
Created on Apr 25, 2010

@author: mpastern@redhat.com
'''

from suds.client import Client, MethodSelector
from suds import WebFault
import traceback as tb
import logging

from org.ovirt.engine.ui.sdk.internals import config
from org.ovirt.engine.ui.sdk.internals.methodSignature import MethodSignature 
from org.ovirt.engine.ui.sdk.internals.threadingBrokers import ThreadingBroker
import org.ovirt.engine.ui.sdk.containers.errorsContainer as Exceptions
#import time

class Instance(object):
    __version__ = '2.3.1'
    __client = None
    __methodsContainer = None
    __methodsSignaturesContainer = []
    __deitalsOrientedVerbsMappingContainer = []
    __typesContainer = []
    __INIT_TTL__ = 180
    __metaDataEndPoint__ = 'getDeitalsOrientedVerbsMapping'
#__brokersContainer = None
    __confObj = None
    
    def getConfiguration(self):
        return self.__confObj
    
    def __init__(self, user='', password=''):
        self.__confObj = config.getConfig() 
        if(self.__checkArgs(self.__confObj)):
            self.initLogger(self.__confObj["Debug"])
#TODO: Apply all configurations on "__client".
            #start = time.time()            
            self.__client = Client(url=self.__confObj["Url"])#, port=__confObj["Port"])#, timeout=cURLConnectionTimeout,retxml=cRetxml)
            #print 'Time to create suds client: %s seconds.\n' % (time.time()-start)
            if(self.__client == None):
                raise Exceptions.ClientGeneratingFailure(self.__confObj["Url"])
                        
            self.__storeTypes()                        
            self.__buildDeitalsOrientedVerbsMappingContainer()
            self.__buildConteiners()
            
            #self.__brokersContainer=self.__defineBroker()
            Instance.__init__ = Instance.__nomore__
            return

    def get_methods_container(self):
        return self.__methodsContainer


    def get_methods_signatures_container(self):
        return self.__methodsSignaturesContainer


    def get_types_container(self):
        return self.__typesContainer


    def get_conf_obj(self):
        return self.__confObj

    
    def __buildDeitalsOrientedVerbsMappingContainer(self):
        #epMethod = None        
        epMethod = self.__getDeitalsOrientedVerbsMappingEndPoint()
        if(epMethod <> None):
            self.__deitalsOrientedVerbsMappingContainer.\
                extend(self.__invokeMethod(epMethod))
        else:               
            raise Exceptions.\
                    ServiceMetadataEndPointLocationFailure(self.__metaDataEndPoint__)   
                         
    def __buildConteiners(self):
        
        cThreads=[]
        cTargets=[self.__createMethodsContainers,\
                  self.__createMethodSignatures]
        
        for targetId in range(len(cTargets)):
            cThreads.append(\
                        ThreadingBroker(\
                                name=cTargets[targetId].__name__+'_Thread',
                                target=cTargets[targetId],
                                kwargs={'lock':ThreadingBroker.getThreadLock()}))
            cThreads[targetId].start()
            cThreads[targetId].join(self.__INIT_TTL__)        
            
        for trd in cThreads:
            if(trd.isAlive()):raise Exceptions.\
                    RhevmClientHandlerInitiationTimeout(self.__INIT_TTL__)
        
    def __checkArgs(self, confObj={}):
#TODO: Check all conf. arguments validity.
        if((not confObj.has_key("Url")) or confObj["Url"] == ''):
            raise Exceptions.NoDefenitionForClientURL(confObj) 
        else:
            return True
    def __nomore__(self, user='', password=''):
        raise Exceptions.NoFurtherEntries(type(self).__module__)
    
    def getClient(self):
        return self.__client
    
#    def getBrokersContainer(self):         
#        return self.__brokersContainer

    '''Returns types advertised by WSDL.'''    
    def getTypes(self):
        return self.__typesContainer
    
    def getMethodsSignatures(self):
        return self.__methodsSignaturesContainer
#    def __defineBroker(self):
#        return BrokersConstructor(self).getContainer()

    def __getMethod(self,name,methodsContainer):
        return MethodSelector(self.__client,\
                              methodsContainer, '').\
                                    __getitem__(name) 
    def __getDeitalsOrientedVerbsMappingEndPoint(self,serviceId=0,portId=0):
        mc = {}     
        if(self.__client.wsdl.services[serviceId].ports[portId].methods.keys().\
                __contains__(self.__metaDataEndPoint__)): 
            mc [self.__metaDataEndPoint__] = self.__client.wsdl.services[serviceId].ports[portId].methods.__getitem__(self.__metaDataEndPoint__)   
            return self.__getMethod(self.__metaDataEndPoint__,mc)
        return None
    
    def __createMethodsContainers(self,lock=ThreadingBroker.getThreadLock(), serviceId=0, portId=0):
#TODO: Check method's overload support.
        lock.acquire()
        methodsContainer = {}            
        i = 0
        
        for methodName in self.__deitalsOrientedVerbsMappingContainer:
            method = self.__client.wsdl.services[serviceId].ports[portId].methods.\
                __getitem__(methodName)
            if(method <> None):
                if(methodsContainer.has_key(method.name)):
                    methodsContainer[method.name + (++i)] = method
                else:
                    methodsContainer[method.name] = method   
            else:
                raise Exceptions.MethodNotFound(methodName)
            
        self.__methodsContainer = methodsContainer
        lock.release()
        
    def __createMethodSignatures(self,lock=ThreadingBroker.getThreadLock(), serviceId=0, portId=0):
        lock.acquire() 
        res=None
        if(self.__client.wsdl.services[serviceId].ports[portId].methods):        
            if(self.__client.wsdl.services[serviceId].ports[portId].methods.values()[0].soap.style == 'rpc'):
                res= self.__getRpcMethodsSignatures(self.__methodsContainer.values())                 
                #res= self.__getRpcMethodsSignatures(self.__client.wsdl.services[serviceId].ports[portId].methods.values()) 
            elif(self.__client.wsdl.services[serviceId].ports[portId].methods.values()[0].soap.style == 'document'):
                res= self.__getDocMethodsSignatures()
            
        self.__methodsSignaturesContainer = res
        lock.release()
        
    def __getRpcMethodsSignatures(self, searchAt, serviceId=0, portId=0):
        methodsSignaturesContainer = []
        returnType = ''
        name = ''
        params = {}
        for method in self.__client.wsdl.services[serviceId].ports[portId].methods.values():
            #returnType = self.__getRpcMethodsReturnType(method)
            returnType = ''
#TODO: Add method return type             
            name = method.name
            params = {}
            i = 0
            for part in method.soap.input.body.parts:
                if(part.type <> None):
                    param = {}
                    param[part.name] = unicode.encode(part.type[0])
#TODO: Set 'Required' on method's arg/s
                    #param['___Required___']=False
                    params[i] = param
                    i += 1
            methodsSignaturesContainer.append(MethodSignature(self, '', returnType, name, params))
        return methodsSignaturesContainer
    
    def __getRpcMethodsReturnType(self, method):
        if(method.soap.output.body.parts):
            return unicode.encode(method.soap.output.body.parts[0].type[0])
        else:
            return "void"
        
    def __getDocMethodsSignatures(self, serviceId=0, portId=0):   
        returnType = ''
        name = ''
        params = {}
        methodsSignaturesContainer = []
        
        for item in self.__client.sd[serviceId].ports[portId][1]: 
            if(self.__deitalsOrientedVerbsMappingContainer.__contains__(item[0])):
                #returnType = self.__getDocMethodsReturnType(self.__client.sd[0].ports[0][0].binding.operations)
                returnType = ''
#TODO: Add method return type                  
                name = item[0]
                params = {}
                i = 0
                for member in item[1]:
                    param = {}
                    param[member[1].name] = member[1].type[0]
#TODO: Set 'Required' on method's arg/s
                    #param['___Required___']=False
                    params[i] = param
                    i += 1
                methodsSignaturesContainer.append(MethodSignature(self, '', returnType, name, params))
        return methodsSignaturesContainer
    
    def __getDocMethodsReturnType(self, methodOutput):
        if(methodOutput):
            #return unicode.encode(methodOutput)
            return ''
        else:
            return "void"
    def __invokeMethod(self, method, *args,**kwargs):
        try:                
            return method.__call__(*args,**kwargs)
        except WebFault, f:
            print f
            print f.fault
        except Exception, e: 
            print e
            tb.print_exc()
    '''
    Invokes method.
        
    @var methodName: Method Name
    @type methodName: string
    @var args: method's arguments
    @type args: list
    @var kwargs: method's arguments dictionary, e.g {'id'=123}
    @type kwargs: dict
    '''    
    def invokeMethod(self, methodName, *args,**kwargs):
#TODO: Check method's overloads handling by MethodSelector.
        method = self.__getMethod(methodName, self.__methodsContainer)
        if(method == None):
            raise Exceptions.MethodNotFound(methodName)
        return self.__invokeMethod(method,*args,**kwargs)
    def __str__(self):
        return (self.__client.__str__())
    
    def show(self):
        print self.__client.__str__()
        
    def methodsProxy(self):
        return self.__client.service
    
    def createEntity(self, obj):
        return self.__client.factory.create(obj)
    
    def __storeTypes(self,lock=ThreadingBroker.getThreadLock(), serviceId=0):
        lock.acquire() 
        internalTypes = []        
        for tp in self.__client.sd[serviceId].types:
            if(not internalTypes.__contains__(tp[1].name)):
                        internalTypes.append(tp[1].name)
        self.__typesContainer = internalTypes
        lock.release()
        
    def getMethodSignatureByName(self,name):
        methods = []
        if(not len(self.__methodsSignaturesContainer)==0):
            for ms in self.__methodsSignaturesContainer:
                if(ms.getName() == name):                    
                    methods.append(ms)
        return methods  
    
    def initLogger(self, debug):
        if(debug == True):
            logging.basicConfig(level=logging.INFO)
            logging.getLogger('suds.client').setLevel(logging.DEBUG)
            logging.getLogger('suds.metrics').setLevel(logging.DEBUG)
            logging.getLogger('suds.resolver').setLevel(logging.DEBUG)            
            logging.getLogger('suds').setLevel(logging.DEBUG)
            
    methodsContainer = property(get_methods_container, None, None, "methodsContainer's docstring")
    methodsSignaturesContainer = property(get_methods_signatures_container, None, None, "methodsSignaturesContainer's docstring")
    typesContainer = property(get_types_container, None, None, "typesContainer's docstring")
    confObj = property(get_conf_obj, None, None, None)

#    def initSecurityObject(self):
#        #    security = Security()
#        #    token = UsernameToken('myusername', 'mypassword')
#        #    security.tokens.append(token)
#        #    __client.set_options(wsse=security)
