﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VdcCommon.BusinessEntities;
using System.Xml;
using VdcUtils;
using System.IO;

namespace VdcCommon.Ovf
{
    public class OvfManager
    {
        /// EINAV TODO: DateTimeFormat is currently not in use. Need to find a way
        /// the DateTime.Parse/TryParse will surely work.
        public static string DateTimeFormat = "dd/MM/yyy HH:mm:ss";

        public void ExportVm(out string ovfstring, VM vm, List<DiskImage> images)
        {
            XmlDocument document;
            using (OvfWriter ovf = new OvfVmWriter(out document, vm, images))
            {
                BuildOvf(ovf);
            }
            // document.outerxml will be valid only out of the using block
            // because the Dispose closing the document
            ovfstring = document.OuterXml;
        }

        public void ExportTemplate(out string ovfstring, VmTemplate vmTemplate, List<DiskImage> images)
        {
            XmlDocument document = new XmlDocument();
            using (OvfWriter ovf = new OvfTemplateWriter(out document, vmTemplate, images))
            {
                BuildOvf(ovf);
            }
            // document.outerxml will be valid only out of the using block
            // because the Dispose closing the document
            ovfstring = document.OuterXml;
        }

        public void ImportVm(string ovfstring, out VM vm, out List<DiskImage> images)
        {
            XmlDocument document = new XmlDocument();
            document.LoadXml(ovfstring);

            vm = new VM();
            images = new List<DiskImage>();

            OvfReader ovf = new OvfVmReader(document, vm, images);

            BuildOvf(ovf);

            // this is static data for all images:
            foreach (DiskImage image in images)
            {
                image.vm_guid = vm.StaticData.vm_guid;
            }
        }

        public void ImportTemplate(string ovfstring, out VmTemplate vmTemplate, out List<DiskImage> images)
        { 
            XmlDocument document = new XmlDocument();
            document.LoadXml(ovfstring);

            vmTemplate = new VmTemplate();
            images = new List<DiskImage>();

            OvfReader ovf = new OvfTemplateReader(document, vmTemplate, images);

            BuildOvf(ovf);

            // this is static data for all images:
            foreach (DiskImage image in images)
            {
                image.container_guid = vmTemplate.vmt_guid;
            }
        }

        public bool IsOvfTemplate(string ovfstring)
        {
            return new OvfParser(ovfstring).IsTemplate();
        }

        private void BuildOvf(IOvfBuilder builder)
        {
            builder.BuildReference(); 
            builder.BuildNetwork(); 
            builder.BuildDisk(); 
            builder.BuildVirtualSystem(); 
        }
    }
}
