﻿using System.Runtime.Serialization;

namespace VdcCommon.BusinessEntities
{
    
    public partial class FenceStatusReturnValue
    {
        public bool IsSucceeded
        {
            get
            {
                return (string.IsNullOrEmpty(Message)  || Message.ToLower() == "done");
            }
        }

        public override string ToString()
        {
            const string MSG = "Host Status is: ";
            const string TEST_SUCCEEDED = "Test Succeeded, ";
            const string TEST_FAILED = "Test Failed, ";
            const string SEP = ". ";
			const string FAILED_MESSAGE_HEADER = "The fence-agent script reported the following error: ";
            return (IsSucceeded)
                       ?
                           TEST_SUCCEEDED + MSG + Status 
                       :
						   TEST_FAILED + MSG + Status + SEP + FAILED_MESSAGE_HEADER + Message;

        }
    }
}
