﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace VdcCommon.BusinessEntities
{
    public partial class ImagesActionsParametersBase : StorageDomainParametersBase
    {
        public ImagesActionsParametersBase(Guid imageId)
            : base(Guid.Empty)
        {
            ImageId = imageId;
        }
        public ImagesActionsParametersBase()
        {
        }

    }
    public partial class ImagesContainterParametersBase : ImagesActionsParametersBase
    {
        public ImagesContainterParametersBase() { }

        public ImagesContainterParametersBase(Guid imageId, string drive, Guid containerId) :
                                                base (imageId)
        {
            _drive = string.IsNullOrEmpty(drive) ? _defaultDrive : drive;
            _containerId = containerId;
        }
    }

    public partial class MergeSnapshotParamenters : VmOperationParameterBase
    {
        public MergeSnapshotParamenters() { }

        public MergeSnapshotParamenters(Guid sourceVmSnapshotId, Guid? destVmSnapshotId, Guid vmGuid)
            : base(vmGuid)
        {
            _sourceVmSnapshotId = sourceVmSnapshotId;
            _destVmSnapshotId = destVmSnapshotId;
        }
    }    
    public partial class CreateImageTemplateParameters : ImagesActionsParametersBase
    {
        public CreateImageTemplateParameters() { }

        public CreateImageTemplateParameters(Guid imageId, 
                                            Guid vmTemplateId,
                                            string vmTemplateName, Guid vmId) : base(imageId)
        {
            VmTemplateId = vmTemplateId;
            VmTemplateName = vmTemplateName;
            VmId = vmId;
        }
    }

    public partial class AddImageFromScratchParameters : ImagesActionsParametersBase
    {
        public AddImageFromScratchParameters() { }

        public AddImageFromScratchParameters(Guid imageId, Guid vmTemplateId, DiskImageBase diskInfo) : base(imageId)
        {
            MasterVmId = vmTemplateId;
            DiskInfo = diskInfo;
        }
    }

    public partial class AddImageFromImportParameters : AddImageFromScratchParameters
    {

        public AddImageFromImportParameters() { }

        public AddImageFromImportParameters(Guid imageId,
            Guid vmTemplateId,
            DiskImageBase diskInfo,
            string candidateID,
            string path,
            ImportCandidateSourceEnum source,
            bool force)

            : base(imageId, vmTemplateId, diskInfo)
        {
            CandidateID = candidateID;
            Path = path;
            Source = source;
            Force = force;
        }
    }

    public partial class CreateSnapshotFromTemplateParameters : ImagesActionsParametersBase
    {
        public CreateSnapshotFromTemplateParameters() { }
        public CreateSnapshotFromTemplateParameters(Guid imageId,
                                            Guid vmId)
            : base(imageId)
        {
            VmId = vmId;
        }
    }

	public partial class MoveOrCopyImageGroupParameters : ImagesContainterParametersBase
    {
        public MoveOrCopyImageGroupParameters() { }
        public MoveOrCopyImageGroupParameters(Guid containerId, Guid imageGroupId, Guid leafSnapshotID, Guid storageDomainId, ImageOperation operation)
            : base(leafSnapshotID, string.Empty, containerId)
        {
            StorageDomainId = storageDomainId;
            ImageGroupID = imageGroupId;
            Operation = operation;
            UseCopyCollapse = false;
            VolumeFormat = VolumeFormat.Unassigned;
            VolumeType = VolumeType.Unassigned;
            PostZero = false;
            ForceOverride = false;
        }

    }
	public partial class MoveMultipleImageGroupsParameters : ImagesContainterParametersBase
	{
        private string BuildImageDictString()
        {
            StringBuilder sb = new StringBuilder();
            foreach (DiskImage disk in ImagesList)
            {
                sb.Append("'")
                    .Append(disk.image_group_id.ToString())
                    .Append("'")
                    .Append(": ")
                    .Append("'")
                    .Append(disk.wipe_after_delete.ToString())
                    .Append("'")
                    .Append(", ");
            }
            return sb.ToString().TrimEnd(' ', ',');
        }
	}
}
