﻿using System;
using System.Collections.Generic;

namespace VdcCommon.BusinessEntities
{
    public partial class TagsActionParametersBase : VdcActionParametersBase
    {
        public TagsActionParametersBase() { }

        public TagsActionParametersBase(Guid tagId)
        {
            TagId = tagId;
        }
    }
    public partial class TagsOperationParameters : TagsActionParametersBase
    {
        public TagsOperationParameters() { }

        public TagsOperationParameters(tags tag)
            : base(tag.tag_id)
        {
            _tag = tag;
        }
    }
    public partial class MoveTagParameters : TagsActionParametersBase
    {
        public MoveTagParameters() { }

        public MoveTagParameters(Guid tagId, Guid newParentId)
            : base(tagId)
        {
            _newParentId = newParentId;
        }
    }
    public partial class AttachEntityToTagParameters : TagsActionParametersBase
    {
        public AttachEntityToTagParameters() { }

        public AttachEntityToTagParameters(Guid tagId, List<Guid> entitiesId)
            : base(tagId)
        {
            _entitiesId = entitiesId.ToArray();
        }
    }
    public partial class AttachVdsToTagParameters : TagsActionParametersBase
    {
        public AttachVdsToTagParameters() { }

        public AttachVdsToTagParameters(Guid tagId, List<Guid> entitiesId)
            : base(tagId)
        {
            List<guid> tempList = new List<guid>();
            foreach (Guid entity in entitiesId)
            {
                tempList.Add((guid)entity);
            }
            _entitiesId = tempList.ToArray();
        }
    }
}