﻿using System;

namespace VdcCommon.BusinessEntities
{
    public partial class VdsGroupParametersBase : VdcActionParametersBase
    {
        public VdsGroupParametersBase(Guid vdsGroupId)
        {
            _vdsGroupId = vdsGroupId;
        }
        public VdsGroupParametersBase()
        {
        }
    }
    public partial class VdsGroupOperationParameters : VdsGroupParametersBase
    {
        public VdsGroupOperationParameters(VDSGroup group) : base (group.ID)
        {
            _vdsGroup = group;
        }
        public VdsGroupOperationParameters()
        {
        }
    }

    public partial class AttachNetworkToVdsGroupParameter : VdsGroupOperationParameters
    {
        public AttachNetworkToVdsGroupParameter() { }

        public AttachNetworkToVdsGroupParameter(VDSGroup group, network net)
            : base(group)
        {
            Network = net;
        }
    }

    public partial class DisplayNetworkToVdsGroupParameters : VdsGroupOperationParameters
    {
        public DisplayNetworkToVdsGroupParameters() { }

        public DisplayNetworkToVdsGroupParameters(VDSGroup group, network net, bool is_display) 
            : base (group)
        {
            Network = net;
            _is_display = is_display;
        }
    }
}
