﻿using System;
using System.Collections.Generic;
using System.Runtime.Serialization;

namespace VdcCommon.BusinessEntities
{
    public partial class AddVmTemplateParameters
    {
        public AddVmTemplateParameters()
        {
        }
        public AddVmTemplateParameters(VM masterVm, string name, string description)
        {
            vm = masterVm;
            Name = name;
            _description = description;
        }
    }

    public partial class AddVmTemplateFromImportParameters : AddVmTemplateParameters
    {
        
        public AddVmTemplateFromImportParameters()
        {
            this.VmTemplateNewName = null;
        }
        public AddVmTemplateFromImportParameters(
            CandidateInfoParameters candidateInfoParameters,
            string vmTemplateNewName,
            bool force)

            : base(new VM(), string.Empty, string.Empty)
        {
            CandidateInfoParameters = candidateInfoParameters;
            VmTemplateNewName = vmTemplateNewName;
            Force = force;
        }
    }

    public partial class UpdateVmTemplateParameters
    {
        public UpdateVmTemplateParameters() { }

        public UpdateVmTemplateParameters(VmTemplate vmTemplate)
        {
            _vmTemplate = vmTemplate;
        }
    }
    
    public partial class VmTemplateParametersBase : VdcActionParametersBase
    {
        public VmTemplateParametersBase() { }

        public VmTemplateParametersBase(Guid vmTemplateId)
        {
            _vmTemplateId = vmTemplateId;
        }
    }
    
    public partial class VmTemplateImportExportParameters : VmTemplateParametersBase
    {
        public VmTemplateImportExportParameters() { }

        public VmTemplateImportExportParameters(Guid vmTemplateId, Guid storageDomainId, Guid storagePoolId) : base(vmTemplateId)
        {
            this.StorageDomainId = storageDomainId;
            this.StoragePoolId = storagePoolId;
        } 
    }

    public partial class ExportVmTemplateParameters : VmTemplateParametersBase
    {
        public ExportVmTemplateParameters() { }

        public ExportVmTemplateParameters(Guid vmTemplateId, bool force, string path)
            : base(vmTemplateId)
        {
            Force = force;
            Path = path;
        }
    }

	public partial class AddVmTemplateInterfaceParameters : VmTemplateParametersBase
	{
		public AddVmTemplateInterfaceParameters() { }

		public AddVmTemplateInterfaceParameters(Guid vmtId, VmNetworkInterface iface)
			: base(vmtId)
		{
			Interface = iface;
		}
	}

	public partial class RemoveVmTemplateInterfaceParameters : VmTemplateParametersBase
	{
		public RemoveVmTemplateInterfaceParameters() { }

		public RemoveVmTemplateInterfaceParameters(Guid vmtId, Guid ifaceId)
			: base(vmtId)
		{
			interfaceField = new VmNetworkInterface();
			interfaceField.Id = ifaceId;
		}
	}
}
