﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.Serialization;
using VdcCommon.BusinessEntities;
using System.Xml.Serialization;

namespace VdcCommon.BusinessEntities
{
	#region Import Queries Parameters

    
    public partial class GetAllImportCandidatesQueryParameters : VdcQueryParametersBase
    {
        public GetAllImportCandidatesQueryParameters() { }

        public GetAllImportCandidatesQueryParameters(string path, ImportCandidateTypeEnum candidateType)
        {
            Path = path;
            CandidateType = candidateType;
        }

        public override RegisterableQueryReturnDataType GetReturnedDataTypeByVdcQueryType(VdcQueryType queryType)
        {
            return RegisterableQueryReturnDataType.UNDEFINED;
        }
    }

	
    public partial class GetImportCandidatesQueryParameters : VdcQueryParametersBase
	{
  
        public GetImportCandidatesQueryParameters() { }

		public GetImportCandidatesQueryParameters(
			string path,
			ImportCandidateSourceEnum candidateSource,
			ImportCandidateTypeEnum candidateType)
		{
			Path = path;
			CandidateSource = candidateSource;
			CandidateType = candidateType;
		}

        public override RegisterableQueryReturnDataType GetReturnedDataTypeByVdcQueryType(VdcQueryType queryType)
        {
            return RegisterableQueryReturnDataType.UNDEFINED;
        }
	}

	
    public partial class CandidateInfoParameters : GetImportCandidatesQueryParameters
	{
       
        public CandidateInfoParameters() { }

		public CandidateInfoParameters(
			string candidateIdOrName,
			bool isName,
			string path,
			ImportCandidateSourceEnum candidateSource,
			ImportCandidateTypeEnum candidateType)
			: base(path, candidateSource, candidateType)
		{
			CandidateIdOrName = candidateIdOrName;
			IsName = isName;
		}

        public override RegisterableQueryReturnDataType GetReturnedDataTypeByVdcQueryType(VdcQueryType queryType)
        {
            return RegisterableQueryReturnDataType.UNDEFINED;
        }
	}

	#endregion Import Queries Parameters

	#region Import Candidate Info Classes

	
	public abstract partial class ImportCandidateInfoBase
	{  
        public ImportCandidateInfoBase() { }

		public abstract string CandidateDisplayName { get; }
	}

	
    public partial class VmCandidateInfo : ImportCandidateInfoBase
	{
        public VmCandidateInfo() { }

        [XmlIgnoreAttribute]
        public override string CandidateDisplayName
		{
			get
			{
                return VmData.vm_name;
			}
		}
	}

	
    public partial class TemplateCandidateInfo : ImportCandidateInfoBase
	{
        public TemplateCandidateInfo() { }

       [XmlIgnoreAttribute]
        public override string CandidateDisplayName
        {
            get
            {
                return VmTemplateData.name;
            }
        }
	}
	
	#endregion Import Candidate Info Classes
}
