using System.Collections.Generic;
//using VdcUtils;

namespace SearchBackend
{
    class AdUserConditionFieldAutoCompleter : BaseConditionFieldAutoCompleter
    {
        
        public AdUserConditionFieldAutoCompleter()
        {
            //Building the basic vervs Dict
			mVerbs.Add("NAME", "NAME");
            mVerbs.Add("USERNAME", "USERNAME");
            if (SyntaxCheckerFactory.ConfigAuthenticationMethod.ToUpper() == "LDAP")
            {
                mVerbs.Add("LASTNAME", "LASTNAME");
                mVerbs.Add("DEPARTMENT", "DEPARTMENT");
                mVerbs.Add("TITLE", "TITLE");
            }
			mVerbs.Add("ALLNAMES", "ALLNAMES");

            //Building the autoCompletion Dict
            buildCompletions();
            //Building the types dict
            TypeDictionary.Add("NAME", typeof(string));
            TypeDictionary.Add("USERNAME", typeof(string));
            if (SyntaxCheckerFactory.ConfigAuthenticationMethod.ToUpper() == "LDAP")
            {
                TypeDictionary.Add("LASTNAME", typeof(string));
                TypeDictionary.Add("DEPARTMENT", typeof (string));
                TypeDictionary.Add("TITLE", typeof (string));
            }
            //building the ColumnName Dict
            mColumnNameDict.Add("NAME", "givenname");
            mColumnNameDict.Add("USERNAME", "samaccountname");
            if (SyntaxCheckerFactory.ConfigAuthenticationMethod.ToUpper() == "LDAP")
            {
                mColumnNameDict.Add("LASTNAME", "sn");
                mColumnNameDict.Add("DEPARTMENT", "department");
                mColumnNameDict.Add("TITLE", "title");
            }
            //Building the validation dict
            valueValidationFunction charValidation = validCahracters;
            foreach (string key in mVerbs.Keys)
            {
                List<valueValidationFunction> curList = new List<valueValidationFunction>();
                curList.Add(charValidation);
                mValidationDict.Add(key, curList);
            }
        }

        public override IAutoCompleter getFieldRelationshipAutoCompleter(string fieldName)
        {
            IAutoCompleter retval = new StringConditionRelationAutoCompleter();
            return retval;
        }

    }
}
