using System;
using System.Collections.Generic;
using System.Text;

namespace SearchBackend
{
    public interface IAutoCompleter
    {
        string[] getCompletion(string wordPart);
        bool validate(string text);
        bool validateCompletion(string text);
        string changeCaseDisplay(string text);
    }

    public delegate bool valueValidationFunction(string field, string value);

    public interface IConditionValueAutoCompleter : IAutoCompleter
    {
        string convertFieldEnumValueToActualValue(string fieldValue);
    }


    /// <summary>
    /// An interface to be implemented by all Condition fields auto completers
    /// </summary>
    public interface IConditionFieldAutoCompleter : IAutoCompleter
    {
        bool validateFieldValue(string fieldName, string fieldValue);
        string getDbFieldName(string fieldName);
        Type getDbFieldType(string fieldName);
        IAutoCompleter getFieldRelationshipAutoCompleter(string fieldName);
        IConditionValueAutoCompleter getFieldValueAutoCompleter(string fieldName);
        string buildFreeTextConditionSql(string tableName, string relations, string value);
        string buildConditionSql(string fieldName, string customizedValue, string customizedRelation, string tableName);
        void formatValue(string fieldName, ref string relations, ref string value); 
    }

    public interface ISyntaxChecker
    {
        SyntaxContainer analyzeSyntaxState(string searchText, bool final);
        SyntaxContainer getCompletion(string searchText);
        //string generateQueryFromSyntaxContainer(SyntaxContainer syntax);
    }
}