﻿using System;
using System.Collections.Generic;
using VdcCommon.BusinessEntities;

namespace SearchBackend
{
    class StorageDomainFieldAutoCompleter : BaseConditionFieldAutoCompleter
    {
        public StorageDomainFieldAutoCompleter()
        {
            //Building the basic vervs Dict
            mVerbs.Add("NAME", "NAME");
            mVerbs.Add("STATUS", "STATUS");
            mVerbs.Add("DATACENTER", "DATACENTER");
            mVerbs.Add("TYPE", "TYPE");
            mVerbs.Add("SIZE", "SIZE");
            mVerbs.Add("USED", "USED");
            mVerbs.Add("COMMITTED", "COMMITTED");
            
            //Building the autoCompletion Dict
            buildCompletions();
            //Building the types dict
            TypeDictionary.Add("NAME", typeof(string));
            TypeDictionary.Add("STATUS", typeof(StorageDomainStatus));
            TypeDictionary.Add("DATACENTER", typeof(string));
            TypeDictionary.Add("TYPE", typeof(StorageType));
            TypeDictionary.Add("SIZE", typeof(int));
            TypeDictionary.Add("USED", typeof(int));
            TypeDictionary.Add("COMMITTED", typeof(int));


            
            //building the ColumnName Dict
            mColumnNameDict.Add("NAME", "storage_name");
            mColumnNameDict.Add("STATUS", "storage_domain_shared_status");
            mColumnNameDict.Add("DATACENTER", "storage_pool_name");
            mColumnNameDict.Add("TYPE", "storage_type");
            mColumnNameDict.Add("SIZE", "available_disk_size");
            mColumnNameDict.Add("USED", "used_disk_size");
            mColumnNameDict.Add("COMMITTED", "commited_disk_size");
            
            //Building the validation dict
            buildBasicValidationTable();
        }

        public override IAutoCompleter getFieldRelationshipAutoCompleter(string fieldName)
        {
			 IAutoCompleter retval;
			 switch (fieldName)
			 {
                 case "SIZE":
                 case "USED":
                 case "COMMITTED":
                     retval = new NumericConditionRelationAutoCompleter();
                     break;
				 default:
					 retval = new StringConditionRelationAutoCompleter();
					 break;
			 }
            
            return retval;
        }

        public override IConditionValueAutoCompleter getFieldValueAutoCompleter(string fieldName)
        {
            IConditionValueAutoCompleter retval = null;
            switch (fieldName)
            {
                case "TYPE":
                    retval = new EnumValueAutoCompleter(typeof(StorageType));
                    break;
                case "STATUS":
                    retval = new EnumValueAutoCompleter(typeof(StorageDomainSharedStatus));
                    break;
                default:
                    break;
            }
            return retval;
        }

    }
}
