using System.Collections.Generic;
using System.Text;
//using VdcUtils;




namespace SearchBackend
{

    public enum SyntaxError
    {
        NO_ERROR                            = 0,
        INVALID_SEARCH_OBJECT               = 1,
        COLON_BEFORE_SEARCH_OBJECT          = 2,
        COLON_NOT_NEXT_TO_SEARCH_OBJECT     = 3,
        INVALID_CONDITION_FILED_OR_SORTBY   = 4,
        INVALID_CONDITION_RELATION          = 5,
        INVALID_CONDITION_VALUE             = 6,
        INVALID_SORT_FIELD                  = 7,
        INVALID_SORT_DIRECTION              = 8,
        NOTHING_COMES_AFTER_PAGE_VALUE      = 9,
        CONDITION_CANT_CREATE_RRELATIONS_AC = 10,
        DOT_NOT_NEXT_TO_CROSS_REF_OBJ       = 11,
        INVALID_POST_COLON_PHRASE           = 12,
        INVALID_POST_CONDITION_VALUE_PHRASE = 13,
        CANT_GET_CONDITION_FIELD_AC         = 14,
        CANT_GET_CONDITION_RELATIONS_AC     = 15,
        INVALID_CONDITION_FILED             = 16,
        UNIDENTIFIED_STATE                  = 17,
        INVALID_POST_OR_AND_PHRASE          = 18,
        INVALID_POST_CROSS_REF_OBJ          = 19,
        FREE_TEXT_ALLOWED_ONCE_PER_OBJ      = 20,
        INVALID_CHARECTER                   = 21,
        INVALID_PAGE_FEILD                  = 22
    }


    public class SyntaxObject
    {
        protected SyntaxObjectType          mType;   
        protected string                    mBody       = null;
        protected int[]                     mPos        = new int[2];

        
        public SyntaxObject(SyntaxObjectType type, string body, int startPos, int endPos)
        {
            mType = type;
            mBody = body;
            mPos[0] = startPos;
            mPos[1] = endPos;
        }

        public SyntaxObjectType Type
        {
            get {return mType;}
            set { mType = value; }
        }

        public string Body
        {
            get {return mBody; }
            set { mBody = value; } 
        }

        public int[] Pos
        {
            get {return mPos; }
        }

        public override string ToString()
        {
            string retval = string.Format("body = '{0}' , startPos = {1} , endPos = {2}, type = {3}", mBody, mPos[0], mPos[1], mType);
            return retval;
        }
    }



    public class SyntaxContainer : IEnumerable<SyntaxObject>
    {
        private string              mOrigText                   = null;
        private bool                mValid                      = false;
        private SyntaxError         mError                      = SyntaxError.NO_ERROR;
        private int[]               mErrorPos                   = new int[2];
        private LinkedList<SyntaxObject> mObjList   = null;
        private List<string> mCurrentCompletions    = null;
        public int MaxCount { get; set; }
        

        public bool valid
        {
            get { return mValid; }
            set { mValid = value; }
        }

        public SyntaxError Error
        {
            get { return mError; }
        }

        public int ErrorStartPos
        {
            get { return mErrorPos[0]; }
        }

        public int ErrorEndPos
        {
            get { return mErrorPos[1]; }
        }

        public LinkedListNode<SyntaxObject> First
        {
            get { return mObjList.First; }
        }

        public string getSearchObjectStr()
        {
            string retval = null;
            if (mObjList.First != null)
            {
                retval = getObjSingularName(mObjList.First.Value.Body);
            }
            return retval;
        }

        public SyntaxContainer(string origText)
        {
            mOrigText = origText;
            mValid = false;
            mObjList = new LinkedList<SyntaxObject>();
            mCurrentCompletions = new List<string>();

        }

        public void setErr(SyntaxError errCode, int startPos, int endPos)
        {
            mErrorPos[0] = startPos;
            mErrorPos[1] = endPos;
            mError = errCode;
            mValid = false;
        }

        public void addSyntaxObject(SyntaxObjectType type, string body, int startPos, int endPos)
        {
            SyntaxObject newObj = new SyntaxObject(type, body, startPos, endPos);
            mObjList.AddLast(new LinkedListNode<SyntaxObject>(newObj));
        }

        public SyntaxObjectType getState()
        {
            SyntaxObjectType retval = SyntaxObjectType.BEGIN;
            if (mObjList.Count > 0)
            {
                retval = mObjList.Last.Value.Type;
            }
            return retval;
        }

        public int getLastHandledIndex()
        {
            int retval = 0;
            if (mObjList.Count > 0)
            {
                retval = mObjList.Last.Value.Pos[1];
            }
            return retval;
        }

        public string getPreviousSyntaxObject(int steps, SyntaxObjectType type)
        {
            string retval = string.Empty;
            LinkedListNode<SyntaxObject> obj = mObjList.Last;
            if (mObjList.Count > steps)
            {
                for (int idx = 0; idx < steps; idx++)
                {
                    obj = obj.Previous;
                }
                if (obj.Value.Type == type)
                {
                    retval = obj.Value.Body;
                }
            }
            if ((retval == string.Empty) && ((type == SyntaxObjectType.CROSS_REF_OBJ) || (type == SyntaxObjectType.SEARCH_OBJECT)))
            {
                retval = mObjList.First.Value.Body;
            }
            return retval;
        }

        public SyntaxObjectType getPreviousSyntaxObjectType(int steps)
        {
            SyntaxObjectType retval = SyntaxObjectType.END;
            LinkedListNode<SyntaxObject> obj = mObjList.Last;
            if (mObjList.Count > steps)
            {
                for (int idx = 0; idx < steps; idx++)
                {
                    obj = obj.Previous;
                }
                retval = obj.Value.Type;
            }
            return retval;
        }

        public void addToACList(string[] acArr)
        {
            for (int idx = 0; idx < acArr.Length; idx++)
            {
                mCurrentCompletions.Add(acArr[idx]);
            }
        }

        public string[] getCompletionArray()
        {
            string[] retval = new string[mCurrentCompletions.Count];
            for (int idx = 0; idx < mCurrentCompletions.Count; idx++)
            {
                retval[idx] = mCurrentCompletions[idx];
            }
            return retval;
        }

        public List<string> getCrossRefObjList()
        {
            List<string> retval = new List<string>();
            LinkedListNode<SyntaxObject> curNode = mObjList.First;
            string searchObj = getObjSingularName(getSearchObjectStr());
            while (curNode != null)
            {
                if (curNode.Value.Type == SyntaxObjectType.CROSS_REF_OBJ)
                {
                    string objSingularName = getObjSingularName(curNode.Value.Body);
                    if ((!retval.Contains(objSingularName)) && 
                        (searchObj != objSingularName) )
                    {
                        retval.Add(objSingularName);
                    }
                }
                curNode = curNode.Next;
            }
            return retval;
        }


        public string getObjSingularName(string obj)
        {
            string retval = obj;
            switch (obj)
            {
                case SearchObjects.AD_USER_OBJ_NAME:
                case SearchObjects.AD_USER_PLU_OBJ_NAME:
                    retval = SearchObjects.AD_USER_OBJ_NAME;
                    break;
                case SearchObjects.AUDIT_OBJ_NAME:
                case SearchObjects.AUDIT_PLU_OBJ_NAME:
                    retval = SearchObjects.AUDIT_OBJ_NAME;
                    break;
                case SearchObjects.TEMPLATE_OBJ_NAME:
                case SearchObjects.TEMPLATE_PLU_OBJ_NAME:
                    retval = SearchObjects.TEMPLATE_OBJ_NAME;
                    break;
                case SearchObjects.VDC_USER_OBJ_NAME:
                case SearchObjects.VDC_USER_PLU_OBJ_NAME:
                    retval = SearchObjects.VDC_USER_OBJ_NAME;
                    break;
                case SearchObjects.VDS_OBJ_NAME:
                case SearchObjects.VDS_PLU_OBJ_NAME:
                    retval = SearchObjects.VDS_OBJ_NAME;
                    break;
                case SearchObjects.VM_OBJ_NAME:
                case SearchObjects.VM_PLU_OBJ_NAME:
                    retval = SearchObjects.VM_OBJ_NAME;
                    break;
                case SearchObjects.VDC_POOL_OBJ_NAME:
                case SearchObjects.VDC_POOL_PLU_OBJ_NAME:
                    retval = SearchObjects.VDC_POOL_OBJ_NAME;
                    break;
                case SearchObjects.VDC_CLUSTER_OBJ_NAME:
                case SearchObjects.VDC_CLUSTER_PLU_OBJ_NAME:
                    retval = SearchObjects.VDC_CLUSTER_OBJ_NAME;
                    break;
                case SearchObjects.VDC_STORAGE_POOL_OBJ_NAME:
                case SearchObjects.VDC_STORAGE_DOMAIN_OBJ_NAME:
                    retval = obj;
                    break;
                default:
                    retval = obj;
                    break;

            }
            return retval;
        }

        public override string ToString()
        {
            StringBuilder sb = new StringBuilder("---------------- SyntaxContainer ---------------------");
            sb.AppendLine();
            sb.Append("mOrigText       = ");
            sb.AppendLine(mOrigText);
            sb.Append("Valid           = ");
            sb.AppendLine(mValid.ToString());
            sb.Append("Error           = ");
            sb.AppendLine(mError.ToString());
            sb.Append("CrossRefObjlist = ");
            foreach (string cro in getCrossRefObjList())
            {
                sb.Append(string.Format("{0}, ", cro));
            }
            sb.Append("Syntax object list:");

            LinkedListNode<SyntaxObject> obj = mObjList.First;
            while (obj != null)
            {
                sb.AppendLine("    ");
                sb.Append(obj.Value.ToString());
                obj = obj.Next;
            }
            return sb.ToString();
        }

        public string ToStringBr()
        {
            StringBuilder sb = new StringBuilder("---------------- SyntaxContainer ---------------------");
            sb.Append("<BR>mOrigText       = ");
            sb.Append(mOrigText);
            sb.Append("<BR>Valid           = ");
            sb.Append(mValid);
            sb.Append("<BR>Error           = ");
            sb.Append(mError);
            sb.Append("<BR>Syntax object list:");
            sb.Append("<BR>CrossRefObjlist = ");
            foreach (string cro in getCrossRefObjList())
            {
                sb.Append(string.Format("{0}, ", cro));
            }
            LinkedListNode<SyntaxObject> obj = mObjList.First;
            while (obj != null)
            {
                sb.Append("<BR>    ");
                sb.Append(obj.Value.ToString());
                obj = obj.Next;
            }
            return sb.ToString();
        }

        public bool contains(SyntaxObjectType type, string val)
        {
            bool retval = false;
            LinkedListNode<SyntaxObject> obj = mObjList.First;
            while(obj != null)
            {
                if ((obj.Value.Type == type) && (obj.Value.Body.ToUpper() == val.ToUpper()))
                {
                    retval = true;
                    break;
                }
                obj = obj.Next;
            }
            return retval;
        }

        #region IEnumerable<SyntaxObject> Members

        public IEnumerator<SyntaxObject> GetEnumerator()
        {
            return mObjList.GetEnumerator();
        }

        #endregion

        #region IEnumerable Members

        System.Collections.IEnumerator System.Collections.IEnumerable.GetEnumerator()
        {
            return mObjList.GetEnumerator();
        }

        #endregion
    }
}
