using System;
using VdcCommon.BusinessEntities;

namespace SearchBackend
{
    class VmTemplateConditionFieldAutoCompleter :  BaseConditionFieldAutoCompleter
    {
        public VmTemplateConditionFieldAutoCompleter()
        {
            mVerbs.Add("NAME", "NAME");
            mVerbs.Add("DOMAIN", "DOMAIN");
            mVerbs.Add("OS", "OS");
            mVerbs.Add("CREATIONDATE", "CREATIONDATE");
            mVerbs.Add("CHILDCOUNT", "CHILEDCOUNT");
            mVerbs.Add("MEM", "MEM");
            mVerbs.Add("DESCRIPTION", "DESCRIPTION");
			mVerbs.Add("STATUS", "STATUS");
			mVerbs.Add("CLUSTER", "CLUSTER");
			mVerbs.Add("DATACENTER", "DATACENTER");

            buildCompletions();
            //Building the types dict
            TypeDictionary.Add("NAME", typeof(string));
            TypeDictionary.Add("DOMAIN", typeof(string));
            TypeDictionary.Add("OS", typeof(VmOsType));
            TypeDictionary.Add("CREATIONDATE", typeof(DateTime));
            TypeDictionary.Add("CHILDCOUNT", typeof(int));
            TypeDictionary.Add("MEM", typeof(int));
            TypeDictionary.Add("DESCRIPTION", typeof(string));
			TypeDictionary.Add("STATUS", typeof(VmTemplateStatus));
			TypeDictionary.Add("CLUSTER", typeof(string));
			TypeDictionary.Add("DATACENTER", typeof(string));
			
            //building the ColumnName Dict
            mColumnNameDict.Add("NAME", "name");
            mColumnNameDict.Add("DOMAIN", "domain");
            mColumnNameDict.Add("OS", "os");
            mColumnNameDict.Add("CREATIONDATE", "creation_date");
            mColumnNameDict.Add("CHILDCOUNT", "child_count");
            mColumnNameDict.Add("MEM", "mem_size_mb");
            mColumnNameDict.Add("DESCRIPTION", "description");
			mColumnNameDict.Add("STATUS", "status");
			mColumnNameDict.Add("CLUSTER", "vds_group_name");
			mColumnNameDict.Add("DATACENTER", "storage_pool_name");
			
            //Building the validation dict
            buildBasicValidationTable();
        }


        public override IAutoCompleter getFieldRelationshipAutoCompleter(string fieldName)
        {
            IAutoCompleter retval;
            switch (fieldName)
            {
                case "CREATIONDATE":
                    retval = new TimeConditionRelationAutoCompleter();
                    break;
                case "CHILDCOUNT":
                case "MEM":
                    retval = new NumericConditionRelationAutoCompleter();
                    break;
                default:
                    retval = new StringConditionRelationAutoCompleter();
                    break;
            }
            return retval;
        }
        public override IConditionValueAutoCompleter getFieldValueAutoCompleter(string fieldName)
        {
            IConditionValueAutoCompleter retval = null;
            switch (fieldName)
            {
                case "OS":
                    retval = new EnumValueAutoCompleter(typeof(VmOsType));
                    break;
                case "CREATIONDATE":
                    retval = new DateEnumValueAutoCompleter(typeof(DateEnumForSearch));
                    break;
				case "STATUS":
					retval = new EnumValueAutoCompleter(typeof(VmTemplateStatus));
					break;

                default:
                    break;
            }
            return retval;
        }
    }
}
