using System;
using System.Collections.Generic;
using System.Threading;
using System.Windows.Threading;

namespace org.ovirt.engine.ui.uicompat
{
	public class TaskContext
	{
		private readonly Dispatcher dispatcher;
		public object State { get; private set; }


		public TaskContext(Dispatcher dispatcher, object state)
		{
			this.dispatcher = dispatcher;
			State = state;
		}

		public void InvokeUIThread(ITaskTarget target, object state)
		{
			State = state;
			dispatcher.Invoke(DispatcherPriority.Normal, new Action(() => target.run(this)));
		}
	}
}