using System;
using System.Collections;
using System.Collections.Generic;
using org.ovirt.engine.ui.uicommon;

namespace org.ovirt.engine.ui.uicompat
{
	public sealed class EnumTranslationStrategy : TranslationStrategy
	{
		private readonly IEnumerable enumValues;
		private IList<object> keys;


		public EnumTranslationStrategy(Type type)
			: this(Enum.GetValues(type))
		{
		}

		public EnumTranslationStrategy(IEnumerable enumValues)
		{
			this.enumValues = enumValues;
		}

		public override void Initialize()
		{
			base.Initialize();
			keys = Linq.Cast<object>(enumValues);
		}

		public override object GetKey(string resourceKey)
		{
			//return keys.FirstOrDefault(a => a.ToString() == resourceKey);
			foreach (object a in keys)
			{
				if (a.ToString() == resourceKey)
				{
					return a;
				}
			}

			return null;
		}
	}
}